/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import example.entity.Emp;
import example.entity._Emp;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockConfig;
import org.seasar.doma.internal.jdbc.query.AutoBatchDeleteQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.entity.EntityType;

public class AutoBatchDeleteQueryTest
extends TestCase {
    private final MockConfig runtimeConfig = new MockConfig();

    public void testPrepare() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setName("bbb");
        AutoBatchDeleteQuery query = new AutoBatchDeleteQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp1, emp2));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        AutoBatchDeleteQuery batchDeleteQuery = query;
        AutoBatchDeleteQueryTest.assertEquals((int)2, (int)batchDeleteQuery.getSqls().size());
    }

    public void testOption_default() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setSalary(new BigDecimal(2000));
        emp2.setVersion(new Integer(10));
        AutoBatchDeleteQuery query = new AutoBatchDeleteQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp1, emp2));
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = (PreparedSql)query.getSqls().get(0);
        AutoBatchDeleteQueryTest.assertEquals((String)"delete from EMP where ID = ? and VERSION = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoBatchDeleteQueryTest.assertEquals((int)2, (int)parameters.size());
        AutoBatchDeleteQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoBatchDeleteQueryTest.assertTrue((((PreparedSqlParameter)parameters.get(1)).getWrapper().get() == null ? 1 : 0) != 0);
        sql = (PreparedSql)query.getSqls().get(1);
        AutoBatchDeleteQueryTest.assertEquals((String)"delete from EMP where ID = ? and VERSION = ?", (String)sql.getRawSql());
        parameters = sql.getParameters();
        AutoBatchDeleteQueryTest.assertEquals((int)2, (int)parameters.size());
        AutoBatchDeleteQueryTest.assertEquals((Object)new Integer(20), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        AutoBatchDeleteQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(1)).getWrapper().get());
    }

    public void testOption_ignoreVersion() throws Exception {
        Emp emp1 = new Emp();
        emp1.setId(10);
        emp1.setName("aaa");
        Emp emp2 = new Emp();
        emp2.setId(20);
        emp2.setSalary(new BigDecimal(2000));
        emp2.setVersion(new Integer(10));
        AutoBatchDeleteQuery query = new AutoBatchDeleteQuery((EntityType)_Emp.getSingletonInternal());
        query.setMethod(((Object)((Object)this)).getClass().getDeclaredMethod(this.getName(), new Class[0]));
        query.setConfig((Config)this.runtimeConfig);
        query.setEntities(Arrays.asList(emp1, emp2));
        query.setVersionIgnored(true);
        query.setCallerClassName("aaa");
        query.setCallerMethodName("bbb");
        query.prepare();
        PreparedSql sql = (PreparedSql)query.getSqls().get(0);
        AutoBatchDeleteQueryTest.assertEquals((String)"delete from EMP where ID = ?", (String)sql.getRawSql());
        List parameters = sql.getParameters();
        AutoBatchDeleteQueryTest.assertEquals((int)1, (int)parameters.size());
        AutoBatchDeleteQueryTest.assertEquals((Object)new Integer(10), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
        sql = (PreparedSql)query.getSqls().get(1);
        AutoBatchDeleteQueryTest.assertEquals((String)"delete from EMP where ID = ?", (String)sql.getRawSql());
        parameters = sql.getParameters();
        AutoBatchDeleteQueryTest.assertEquals((int)1, (int)parameters.size());
        AutoBatchDeleteQueryTest.assertEquals((Object)new Integer(20), (Object)((PreparedSqlParameter)parameters.get(0)).getWrapper().get());
    }
}

