/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.mock;

import java.math.BigDecimal;
import junit.framework.TestCase;
import org.seasar.doma.internal.jdbc.mock.MockPreparedStatement;

public class MockPreparedStatementTest
extends TestCase {
    public void testSetString() throws Exception {
        MockPreparedStatement ps = new MockPreparedStatement();
        ps.setString(1, "aaa");
        ps.setString(2, "bbb");
        MockPreparedStatementTest.assertEquals((Object)"aaa", (Object)ps.bindValues.get(0).getValue());
        MockPreparedStatementTest.assertEquals((Object)"bbb", (Object)ps.bindValues.get(1).getValue());
    }

    public void testSetInt() throws Exception {
        MockPreparedStatement ps = new MockPreparedStatement();
        ps.setInt(1, 100);
        ps.setInt(2, 200);
        MockPreparedStatementTest.assertEquals((Object)new Integer(100), (Object)ps.bindValues.get(0).getValue());
        MockPreparedStatementTest.assertEquals((Object)new Integer(200), (Object)ps.bindValues.get(1).getValue());
    }

    public void testSetBigDecimal() throws Exception {
        MockPreparedStatement ps = new MockPreparedStatement();
        ps.setBigDecimal(1, new BigDecimal(10));
        ps.setBigDecimal(2, new BigDecimal(20));
        MockPreparedStatementTest.assertEquals((Object)new BigDecimal(10), (Object)ps.bindValues.get(0).getValue());
        MockPreparedStatementTest.assertEquals((Object)new BigDecimal(20), (Object)ps.bindValues.get(1).getValue());
    }

    public void testSetNull() throws Exception {
        MockPreparedStatement ps = new MockPreparedStatement();
        ps.setNull(1, 4);
        ps.setNull(2, 12);
        MockPreparedStatementTest.assertNull((Object)ps.bindValues.get(0).getValue());
        MockPreparedStatementTest.assertNull((Object)ps.bindValues.get(1).getValue());
    }

    public void testExecuteUpdate() throws Exception {
        MockPreparedStatement ps = new MockPreparedStatement();
        MockPreparedStatementTest.assertEquals((int)1, (int)ps.executeUpdate());
    }

    public void testExecuteUpdate_updatedRows() throws Exception {
        MockPreparedStatement ps = new MockPreparedStatement();
        MockPreparedStatementTest.assertEquals((int)1, (int)ps.executeUpdate());
        ps.updatedRows = 0;
        MockPreparedStatementTest.assertEquals((int)0, (int)ps.executeUpdate());
    }
}

