/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.domain;

import javax.annotation.processing.Processor;
import org.seasar.doma.internal.apt.AptTestCase;
import org.seasar.doma.internal.apt.DomainConvertersProcessor;
import org.seasar.doma.internal.apt.domain.DayConvertersProvider;
import org.seasar.doma.internal.apt.domain.EmptyConvertersProvider;
import org.seasar.doma.internal.apt.domain.ExternalDomainNotSpecifiedProvider;
import org.seasar.doma.message.Message;

public class DomainConvertersProcessorTest
extends AptTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.addOption(new String[]{"-Atest=true"});
    }

    public void testDay() throws Exception {
        DomainConvertersProcessor processor = new DomainConvertersProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(DayConvertersProvider.class);
        this.compile();
        DomainConvertersProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testEmpty() throws Exception {
        DomainConvertersProcessor processor = new DomainConvertersProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(EmptyConvertersProvider.class);
        this.compile();
        DomainConvertersProcessorTest.assertTrue((boolean)this.getCompiledResult());
    }

    public void testExternalDomainNotSpecified() throws Exception {
        DomainConvertersProcessor processor = new DomainConvertersProcessor();
        this.addProcessor(new Processor[]{processor});
        this.addCompilationUnit(ExternalDomainNotSpecifiedProvider.class);
        this.compile();
        DomainConvertersProcessorTest.assertFalse((boolean)this.getCompiledResult());
        this.assertMessage(Message.DOMA4196);
    }
}

