/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.dao;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptTestCase;
import org.seasar.doma.internal.apt.SqlValidator;
import org.seasar.doma.internal.apt.dao.SqlValidationDao;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;
import org.seasar.doma.message.Message;
import org.seasar.doma.wrapper.StringWrapper;

public class SqlValidatorTest
extends AptTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.addSourcePath(new String[]{"src/main/java"});
        this.addSourcePath(new String[]{"src/test/java"});
    }

    public void testBindVariable() throws Exception {
        Class<SqlValidationDao> target = SqlValidationDao.class;
        this.addCompilationUnit(target);
        this.addCompilationUnit(StringWrapper.class);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testBindVariable", String.class);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        SqlValidator validator = new SqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp where name = /* name */'aaa'");
        SqlNode sqlNode = parser.parse();
        sqlNode.accept((SqlNodeVisitor)validator, null);
    }

    public void testBindVariable_list() throws Exception {
        Class<SqlValidationDao> target = SqlValidationDao.class;
        this.addCompilationUnit(target);
        this.addCompilationUnit(StringWrapper.class);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testBindVariable_list", List.class);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        SqlValidator validator = new SqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp where name in /* names */('aaa')");
        SqlNode sqlNode = parser.parse();
        sqlNode.accept((SqlNodeVisitor)validator, null);
    }

    public void testEmbeddedVariable() throws Exception {
        Class<SqlValidationDao> target = SqlValidationDao.class;
        this.addCompilationUnit(target);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testEmbeddedVariable", String.class);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        SqlValidator validator = new SqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp /*# orderBy */");
        SqlNode sqlNode = parser.parse();
        sqlNode.accept((SqlNodeVisitor)validator, null);
    }

    public void testFor() throws Exception {
        Class<SqlValidationDao> target = SqlValidationDao.class;
        this.addCompilationUnit(target);
        this.addCompilationUnit(StringWrapper.class);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testFor", List.class);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        SqlValidator validator = new SqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp where name = /*%for e : names*/ /*e*/'aaa' /*%if e_has_next*/or/*%end*//*%end*/");
        SqlNode sqlNode = parser.parse();
        sqlNode.accept((SqlNodeVisitor)validator, null);
    }

    public void testFor_identifier() throws Exception {
        Class<SqlValidationDao> target = SqlValidationDao.class;
        this.addCompilationUnit(target);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testFor", List.class);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        SqlValidator validator = new SqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp where name = /*%for e : names*/ /*x*/'aaa' /*%if e_has_next*/or/*%end*//*%end*/");
        SqlNode sqlNode = parser.parse();
        try {
            sqlNode.accept((SqlNodeVisitor)validator, null);
            SqlValidatorTest.fail();
        }
        catch (AptException expected) {
            System.out.println(expected.getMessage());
            SqlValidatorTest.assertEquals((Object)Message.DOMA4092, (Object)expected.getMessageResource());
        }
    }

    public void testFor_notIterable() throws Exception {
        Class<SqlValidationDao> target = SqlValidationDao.class;
        this.addCompilationUnit(target);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testFor_notIterable", Iterator.class);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        SqlValidator validator = new SqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp where name = /*%for e : names*/ /*e*/'aaa' /*%if e_has_next*/or/*%end*//*%end*/");
        SqlNode sqlNode = parser.parse();
        try {
            sqlNode.accept((SqlNodeVisitor)validator, null);
            SqlValidatorTest.fail();
        }
        catch (AptException expected) {
            System.out.println(expected.getMessage());
            SqlValidatorTest.assertEquals((Object)Message.DOMA4149, (Object)expected.getMessageResource());
        }
    }

    public void testFor_noTypeArgument() throws Exception {
        Class<SqlValidationDao> target = SqlValidationDao.class;
        this.addCompilationUnit(target);
        this.compile();
        ExecutableElement methodElement = this.createMethodElement(target, "testFor_noTypeArgument", List.class);
        Map<String, TypeMirror> parameterTypeMap = this.createParameterTypeMap(methodElement);
        SqlValidator validator = new SqlValidator(this.getProcessingEnvironment(), methodElement, parameterTypeMap, "aaa/bbbDao/ccc.sql");
        SqlParser parser = new SqlParser("select * from emp where name = /*%for e : names*/ /*e*/'aaa' /*%if e_has_next*/or/*%end*//*%end*/");
        SqlNode sqlNode = parser.parse();
        try {
            sqlNode.accept((SqlNodeVisitor)validator, null);
            SqlValidatorTest.fail();
        }
        catch (AptException expected) {
            System.out.println(expected.getMessage());
            SqlValidatorTest.assertEquals((Object)Message.DOMA4150, (Object)expected.getMessageResource());
        }
    }
}

