/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.sql.SQLException;
import java.util.Collections;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.jdbc.dialect.HsqldbPagingTransformer;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogFormattingVisitor;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.dialect.StandardDialect;

public class HsqldbDialect
extends StandardDialect {
    protected static final int UNIQUE_CONSTRAINT_VIOLATION_ERROR_CODE = -104;

    public HsqldbDialect() {
        this(new HsqldbJdbcMappingVisitor(), new HsqldbSqlLogFormattingVisitor(), new HsqldbExpressionFunctions());
    }

    public HsqldbDialect(JdbcMappingVisitor jdbcMappingVisitor) {
        this(jdbcMappingVisitor, new HsqldbSqlLogFormattingVisitor(), new HsqldbExpressionFunctions());
    }

    public HsqldbDialect(SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(new HsqldbJdbcMappingVisitor(), sqlLogFormattingVisitor, new HsqldbExpressionFunctions());
    }

    public HsqldbDialect(ExpressionFunctions expressionFunctions) {
        this(new HsqldbJdbcMappingVisitor(), new HsqldbSqlLogFormattingVisitor(), expressionFunctions);
    }

    public HsqldbDialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(jdbcMappingVisitor, sqlLogFormattingVisitor, new HsqldbExpressionFunctions());
    }

    public HsqldbDialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor, ExpressionFunctions expressionFunctions) {
        super(jdbcMappingVisitor, sqlLogFormattingVisitor, expressionFunctions);
    }

    @Override
    public String getName() {
        return "hsqldb";
    }

    @Override
    public boolean includesIdentityColumn() {
        return true;
    }

    @Override
    public PreparedSql getIdentitySelectSql(String qualifiedTableName, String columnName) {
        if (qualifiedTableName == null) {
            throw new DomaNullPointerException("qualifiedTableName");
        }
        if (columnName == null) {
            throw new DomaNullPointerException("columnName");
        }
        String rawSql = "call identity()";
        return new PreparedSql(SqlKind.SELECT, rawSql, rawSql, null, Collections.emptyList());
    }

    @Override
    public PreparedSql getSequenceNextValSql(String qualifiedSequenceName, long allocationSize) {
        if (qualifiedSequenceName == null) {
            throw new DomaNullPointerException("qualifiedSequenceName");
        }
        String rawSql = "select next value for " + qualifiedSequenceName + " from information_schema.system_tables where table_name = 'SYSTEM_TABLES'";
        return new PreparedSql(SqlKind.SELECT, rawSql, rawSql, null, Collections.emptyList());
    }

    @Override
    public boolean isUniqueConstraintViolated(SQLException sqlException) {
        if (sqlException == null) {
            throw new DomaNullPointerException("sqlException");
        }
        int code = this.getErrorCode(sqlException);
        return -104 == code;
    }

    @Override
    protected SqlNode toPagingSqlNode(SqlNode sqlNode, long offset, long limit) {
        HsqldbPagingTransformer transformer = new HsqldbPagingTransformer(offset, limit);
        return transformer.transform(sqlNode);
    }

    @Override
    protected SqlNode toForUpdateSqlNode(SqlNode sqlNode, SelectForUpdateType forUpdateType, int waitSeconds, String ... aliases) {
        return sqlNode;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsSequence() {
        return true;
    }

    public static class HsqldbExpressionFunctions
    extends StandardDialect.StandardExpressionFunctions {
    }

    public static class HsqldbSqlLogFormattingVisitor
    extends StandardDialect.StandardSqlLogFormattingVisitor {
    }

    public static class HsqldbJdbcMappingVisitor
    extends StandardDialect.StandardJdbcMappingVisitor {
    }
}

