/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.builder.impl;

import java.lang.reflect.Method;
import java.util.List;
import org.seasar.extension.dxo.builder.impl.AbstractDxoCommandBuilder;
import org.seasar.extension.dxo.command.DxoCommand;
import org.seasar.extension.dxo.command.impl.BeanToBeanDxoCommand;
import org.seasar.extension.dxo.util.DxoUtil;

public class BeanToBeanDxoCommandBuilder
extends AbstractDxoCommandBuilder {
    public DxoCommand createDxoCommand(Class dxoClass, Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        int parameterSize = parameterTypes.length;
        if (parameterSize != 1 && parameterSize != 2) {
            return null;
        }
        Class<?> sourceType = parameterTypes[0];
        Class<?> destType = parameterSize == 1 ? method.getReturnType() : parameterTypes[1];
        Class destElementClass = DxoUtil.getElementTypeOfList(method);
        if (sourceType.isArray()) {
            if (destType.isArray()) {
                return new BeanToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), destType.getComponentType());
            }
            if (List.class.isAssignableFrom(destType) && destElementClass != null) {
                return new BeanToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), destElementClass);
            }
        } else if (List.class.isAssignableFrom(sourceType)) {
            if (destType.isArray()) {
                return new BeanToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), destType.getComponentType());
            }
            if (List.class.isAssignableFrom(destType) && destElementClass != null) {
                return new BeanToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), destElementClass);
            }
        } else if (!destType.isArray() && !List.class.isAssignableFrom(destType)) {
            return new BeanToBeanDxoCommand(dxoClass, method, this.converterFactory, this.getAnnotationReader(), destType);
        }
        return null;
    }
}

