/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.command.GetValueFunction;
import org.seasar.doma.internal.jdbc.command.ResultFetcher;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.wrapper.ObjectWrapper;

public class MapFetcher
implements ResultFetcher<ResultSet, Map<String, Object>> {
    protected final Query query;
    protected final MapKeyNamingType keyNamingType;
    protected Map<Integer, String> indexMap;

    public MapFetcher(Query query, MapKeyNamingType keyNamingType) {
        AssertionUtil.assertNotNull((Object)query, (Object)keyNamingType);
        this.query = query;
        this.keyNamingType = keyNamingType;
    }

    @Override
    public void fetch(ResultSet resultSet, Map<String, Object> map) throws SQLException {
        AssertionUtil.assertNotNull((Object)resultSet, map);
        if (this.indexMap == null) {
            this.indexMap = this.createIndexMap(resultSet.getMetaData());
        }
        JdbcMappingVisitor jdbcMappingVisitor = this.query.getConfig().getDialect().getJdbcMappingVisitor();
        for (Map.Entry<Integer, String> entry : this.indexMap.entrySet()) {
            Integer index = entry.getKey();
            String key = entry.getValue();
            GetValueFunction function = new GetValueFunction(resultSet, index);
            ObjectWrapper wrapper = new ObjectWrapper();
            wrapper.accept(jdbcMappingVisitor, function);
            map.put(key, wrapper.get());
        }
    }

    protected HashMap<Integer, String> createIndexMap(ResultSetMetaData resultSetMeta) throws SQLException {
        HashMap<Integer, String> indexMap = new HashMap<Integer, String>();
        int count = resultSetMeta.getColumnCount();
        for (int i = 1; i < count + 1; ++i) {
            String columnName = resultSetMeta.getColumnLabel(i);
            indexMap.put(i, this.keyNamingType.apply(columnName));
        }
        return indexMap;
    }
}

