/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.SequenceGenerator;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class SequenceGeneratorMirror {
    protected final AnnotationMirror annotationMirror;
    protected AnnotationValue catalog;
    protected AnnotationValue schema;
    protected AnnotationValue sequence;
    protected AnnotationValue initialValue;
    protected AnnotationValue allocationSize;
    protected AnnotationValue implementer;

    protected SequenceGeneratorMirror(AnnotationMirror annotationMirror) {
        AssertionUtil.assertNotNull(annotationMirror);
        this.annotationMirror = annotationMirror;
    }

    public static SequenceGeneratorMirror newInstance(VariableElement field, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror(field, SequenceGenerator.class, env);
        if (annotationMirror == null) {
            return null;
        }
        SequenceGeneratorMirror result = new SequenceGeneratorMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("catalog".equals(name)) {
                result.catalog = value;
                continue;
            }
            if ("schema".equals(name)) {
                result.schema = value;
                continue;
            }
            if ("sequence".equals(name)) {
                result.sequence = value;
                continue;
            }
            if ("initialValue".equals(name)) {
                result.initialValue = value;
                continue;
            }
            if ("allocationSize".equals(name)) {
                result.allocationSize = value;
                continue;
            }
            if (!"implementer".equals(name)) continue;
            result.implementer = value;
        }
        return result;
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public AnnotationValue getCatalog() {
        return this.catalog;
    }

    public AnnotationValue getSchema() {
        return this.schema;
    }

    public AnnotationValue getSequence() {
        return this.sequence;
    }

    public AnnotationValue getInitialValue() {
        return this.initialValue;
    }

    public AnnotationValue getAllocationSize() {
        return this.allocationSize;
    }

    public AnnotationValue getImplementer() {
        return this.implementer;
    }

    public String getCatalogValue() {
        String value = AnnotationValueUtil.toString(this.catalog);
        if (value == null) {
            throw new AptIllegalStateException("catalog");
        }
        return value;
    }

    public String getSchemaValue() {
        String value = AnnotationValueUtil.toString(this.schema);
        if (value == null) {
            throw new AptIllegalStateException("schema");
        }
        return value;
    }

    public String getSequenceValue() {
        String value = AnnotationValueUtil.toString(this.sequence);
        if (value == null) {
            throw new AptIllegalStateException("sequence");
        }
        return value;
    }

    public Long getInitialValueValue() {
        Long value = AnnotationValueUtil.toLong(this.initialValue);
        if (value == null) {
            throw new AptIllegalStateException("initialValue");
        }
        return value;
    }

    public Long getAllocationSizeValue() {
        Long value = AnnotationValueUtil.toLong(this.allocationSize);
        if (value == null) {
            throw new AptIllegalStateException("allocationSize");
        }
        return value;
    }

    public TypeMirror getImplementerValue() {
        TypeMirror value = AnnotationValueUtil.toType(this.implementer);
        if (value == null) {
            throw new AptIllegalStateException("implementer");
        }
        return value;
    }
}

