/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.criteria.ColumnCriterion;
import org.seasar.doma.internal.jdbc.criteria.CriterionVisitor;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityPropertyTypeVisitor;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.EntityTypeVisitor;

public abstract class AbstractEntityType<E>
implements EntityType<E> {
    protected AbstractEntityType() {
    }

    @Override
    public boolean contains(ColumnCriterion<?> column) {
        return this.getEntityPropertyTypes().contains(column);
    }

    @Override
    public List<? extends ColumnCriterion<?>> getColumns() {
        return this.getEntityPropertyTypes();
    }

    @Override
    public Map<String, Object> getCopy(E entity) {
        List propertyTypes = this.getEntityPropertyTypes();
        HashMap<String, Object> properties = new HashMap<String, Object>(propertyTypes.size());
        for (EntityPropertyType<E, ?> p : propertyTypes) {
            properties.put(p.getName(), p.getCopy(entity));
        }
        return properties;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CriterionVisitor<R, P, TH> visitor, P p) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof EntityPropertyTypeVisitor) {
            EntityTypeVisitor v = (EntityTypeVisitor)visitor;
            return v.visitEntityType(this, p);
        }
        return visitor.visitUnknownExpression(this, p);
    }
}

