/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.seasar.doma.internal.jdbc.query.BatchModifyQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AutoBatchModifyQuery<E>
implements BatchModifyQuery {
    protected static final String[] EMPTY_STRINGS = new String[0];
    protected List<EntityPropertyType<E, ?>> targetPropertyTypes;
    protected List<EntityPropertyType<E, ?>> idPropertyTypes;
    protected String[] includedPropertyNames = EMPTY_STRINGS;
    protected String[] excludedPropertyNames = EMPTY_STRINGS;
    protected final EntityType<E> entityType;
    protected Method method;
    protected Config config;
    protected String callerClassName;
    protected String callerMethodName;
    protected VersionPropertyType<? super E, E, ?, ?> versionPropertyType;
    protected boolean optimisticLockCheckRequired;
    protected boolean autoGeneratedKeysSupported;
    protected boolean executable;
    protected SqlExecutionSkipCause executionSkipCause = SqlExecutionSkipCause.BATCH_TARGET_NONEXISTENT;
    protected List<PreparedSql> sqls;
    protected List<E> entities;
    protected E currentEntity;
    protected int queryTimeout;
    protected int batchSize;

    public AutoBatchModifyQuery(EntityType<E> entityType) {
        AssertionUtil.assertNotNull(entityType);
        this.entityType = entityType;
    }

    protected void prepareIdAndVersionPropertyTypes() {
        this.idPropertyTypes = this.entityType.getIdPropertyTypes();
        this.versionPropertyType = this.entityType.getVersionPropertyType();
    }

    protected void validateIdExistent() {
        if (this.idPropertyTypes.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2022, this.entityType.getName());
        }
    }

    protected void prepareOptions() {
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
        if (this.batchSize <= 0) {
            this.batchSize = this.config.getBatchSize();
        }
    }

    protected boolean isTargetPropertyName(String name) {
        if (this.includedPropertyNames.length > 0) {
            for (String includedName : this.includedPropertyNames) {
                if (!includedName.equals(name)) continue;
                for (String excludedName : this.excludedPropertyNames) {
                    if (!excludedName.equals(name)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.excludedPropertyNames.length > 0) {
            for (String excludedName : this.excludedPropertyNames) {
                if (!excludedName.equals(name)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setEntities(Iterable<E> entities) {
        AssertionUtil.assertNotNull(entities);
        if (entities instanceof Collection) {
            this.entities = new ArrayList((Collection)entities);
        } else {
            this.entities = new ArrayList();
            for (E entity : entities) {
                this.entities.add(entity);
            }
        }
        this.sqls = new ArrayList<PreparedSql>(this.entities.size());
    }

    public List<E> getEntities() {
        return this.entities;
    }

    public void setCallerClassName(String callerClassName) {
        this.callerClassName = callerClassName;
    }

    public void setCallerMethodName(String callerMethodName) {
        this.callerMethodName = callerMethodName;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setIncludedPropertyNames(String ... includedPropertyNames) {
        this.includedPropertyNames = includedPropertyNames;
    }

    public void setExcludedPropertyNames(String ... excludedPropertyNames) {
        this.excludedPropertyNames = excludedPropertyNames;
    }

    @Override
    public PreparedSql getSql() {
        return this.sqls.get(0);
    }

    @Override
    public String getClassName() {
        return this.callerClassName;
    }

    @Override
    public String getMethodName() {
        return this.callerMethodName;
    }

    @Override
    public List<PreparedSql> getSqls() {
        return this.sqls;
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public boolean isOptimisticLockCheckRequired() {
        return this.optimisticLockCheckRequired;
    }

    @Override
    public boolean isAutoGeneratedKeysSupported() {
        return this.autoGeneratedKeysSupported;
    }

    @Override
    public boolean isExecutable() {
        return this.executable;
    }

    @Override
    public SqlExecutionSkipCause getSqlExecutionSkipCause() {
        return this.executionSkipCause;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public String toString() {
        return this.sqls.toString();
    }
}

