/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.id;

import javax.sql.DataSource;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.RequiresNewController;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityType;

public class IdGenerationConfig {
    protected final Config config;
    protected final EntityType<?> entityType;
    protected final String qualifiedTableName;
    protected final String idColumnName;

    public IdGenerationConfig(Config config, EntityType<?> entityType) {
        this(config, entityType, entityType.getQualifiedTableName(), entityType.getGeneratedIdPropertyType().getColumnName());
    }

    protected IdGenerationConfig(Config config, EntityType<?> entityType, String qualifiedTableName, String idColumnName) {
        AssertionUtil.assertNotNull((Object)config, entityType, (Object)qualifiedTableName, (Object)idColumnName);
        this.config = config;
        this.entityType = entityType;
        this.qualifiedTableName = qualifiedTableName;
        this.idColumnName = idColumnName;
    }

    public DataSource getDataSource() {
        return this.config.getDataSource();
    }

    public String getDataSourceName() {
        return this.config.getDataSourceName();
    }

    public Dialect getDialect() {
        return this.config.getDialect();
    }

    public JdbcLogger getJdbcLogger() {
        return this.config.getJdbcLogger();
    }

    public RequiresNewController getRequiresNewController() {
        return this.config.getRequiresNewController();
    }

    public int getFetchSize() {
        return this.config.getFetchSize();
    }

    public int getMaxRows() {
        return this.config.getMaxRows();
    }

    public int getQueryTimeout() {
        return this.config.getQueryTimeout();
    }

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public String getQualifiedTableName() {
        return this.qualifiedTableName;
    }

    public String getIdColumnName() {
        return this.idColumnName;
    }
}

