/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.Command;
import org.seasar.doma.internal.jdbc.command.ScriptReader;
import org.seasar.doma.internal.jdbc.query.ScriptQuery;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.ScriptException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlParameter;

public class ScriptCommand
implements Command<Void, SelectQuery> {
    protected final ScriptQuery query;
    protected ScriptException savedScriptException;

    public ScriptCommand(ScriptQuery query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void execute() {
        Connection connection = JdbcUtil.getConnection(this.query.getConfig().getDataSource());
        try {
            ScriptReader reader = new ScriptReader(this.query);
            try {
                String sqlText = reader.readSql();
                while (sqlText != null) {
                    ScriptSql sql = new ScriptSql(sqlText, this.query.getScriptFilePath());
                    Statement statement = JdbcUtil.createStatement(connection);
                    try {
                        this.log(sql);
                        this.setupOptions(statement);
                        statement.execute(sqlText);
                    }
                    catch (Exception e) {
                        if (this.query.getHaltOnError()) {
                            throw new ScriptException(e, sql, reader.getLineNumber());
                        }
                        if (this.savedScriptException == null) {
                            this.savedScriptException = new ScriptException(e, sql, reader.getLineNumber());
                        }
                    }
                    finally {
                        JdbcUtil.close(statement, this.query.getConfig().getJdbcLogger());
                    }
                    sqlText = reader.readSql();
                }
            }
            finally {
                reader.close();
            }
        }
        finally {
            JdbcUtil.close(connection, this.query.getConfig().getJdbcLogger());
        }
        this.throwSavedScriptExceptionIfExists();
        return null;
    }

    protected void log(ScriptSql sql) {
        JdbcLogger logger = this.query.getConfig().getJdbcLogger();
        logger.logSql(this.query.getClassName(), this.query.getMethodName(), sql);
    }

    protected void setupOptions(Statement statement) throws SQLException {
        if (this.query.getQueryTimeout() > 0) {
            statement.setQueryTimeout(this.query.getQueryTimeout());
        }
    }

    protected void throwSavedScriptExceptionIfExists() {
        if (this.savedScriptException != null) {
            throw this.savedScriptException;
        }
    }

    protected static class ScriptSql
    implements Sql<SqlParameter> {
        protected final String rawSql;
        protected final String sqlFilePath;

        public ScriptSql(String rawSql, String sqlFilePath) {
            AssertionUtil.assertNotNull((Object)rawSql, (Object)sqlFilePath);
            this.rawSql = rawSql;
            this.sqlFilePath = sqlFilePath;
        }

        @Override
        public SqlKind getKind() {
            return SqlKind.SCRIPT;
        }

        @Override
        public String getRawSql() {
            return this.rawSql;
        }

        @Override
        public String getFormattedSql() {
            return this.rawSql;
        }

        @Override
        public String getSqlFilePath() {
            return this.sqlFilePath;
        }

        @Override
        public List<SqlParameter> getParameters() {
            return Collections.emptyList();
        }
    }
}

