/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.type.AnyType;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.IterableType;
import org.seasar.doma.internal.apt.type.IterationCallbackType;
import org.seasar.doma.internal.apt.type.ReferenceType;
import org.seasar.doma.internal.apt.type.SelectOptionsType;
import org.seasar.doma.internal.apt.type.SimpleDataTypeVisitor;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class QueryParameterMeta {
    protected final VariableElement element;
    protected final ProcessingEnvironment env;
    protected final String name;
    protected final String typeName;
    protected final TypeMirror type;
    protected final String qualifiedName;
    protected final DataType dataType;

    public QueryParameterMeta(VariableElement parameterElement, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)parameterElement, (Object)env);
        this.element = parameterElement;
        this.env = env;
        this.name = ElementUtil.getParameterName(parameterElement);
        if (this.name.startsWith("__")) {
            throw new AptException((MessageResource)Message.DOMA4025, env, (Element)parameterElement, "__");
        }
        this.type = parameterElement.asType();
        this.typeName = TypeMirrorUtil.getTypeName(this.type, env);
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(this.type, env);
        this.qualifiedName = typeElement != null ? typeElement.getQualifiedName().toString() : this.typeName;
        this.dataType = this.createDataType(parameterElement, env);
    }

    protected DataType createDataType(final VariableElement parameterElement, final ProcessingEnvironment env) {
        IterableType iterableType = IterableType.newInstance(this.type, env);
        if (iterableType != null) {
            if (iterableType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4159, env, (Element)parameterElement, new Object[0]);
            }
            if (iterableType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4160, env, (Element)parameterElement, new Object[0]);
            }
            iterableType.getElementType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                    if (dataType.isRawType()) {
                        throw new AptException((MessageResource)Message.DOMA4212, env, (Element)parameterElement, dataType.getQualifiedName());
                    }
                    if (dataType.isWildcardType()) {
                        throw new AptException((MessageResource)Message.DOMA4213, env, (Element)parameterElement, dataType.getQualifiedName());
                    }
                    return null;
                }
            }, null);
            return iterableType;
        }
        EntityType entityType = EntityType.newInstance(this.type, env);
        if (entityType != null) {
            return entityType;
        }
        DomainType domainType = DomainType.newInstance(this.type, env);
        if (domainType != null) {
            if (domainType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4208, env, (Element)parameterElement, domainType.getQualifiedName());
            }
            if (domainType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4209, env, (Element)parameterElement, domainType.getQualifiedName());
            }
            return domainType;
        }
        BasicType basicType = BasicType.newInstance(this.type, env);
        if (basicType != null) {
            return basicType;
        }
        SelectOptionsType selectOptionsType = SelectOptionsType.newInstance(this.type, env);
        if (selectOptionsType != null) {
            return selectOptionsType;
        }
        IterationCallbackType iterationCallbackType = IterationCallbackType.newInstance(this.type, env);
        if (iterationCallbackType != null) {
            if (iterationCallbackType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4110, env, (Element)parameterElement, this.qualifiedName);
            }
            if (iterationCallbackType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4112, env, (Element)parameterElement, this.qualifiedName);
            }
            iterationCallbackType.getReturnType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                    if (dataType.isRawType()) {
                        throw new AptException((MessageResource)Message.DOMA4214, env, (Element)parameterElement, dataType.getQualifiedName());
                    }
                    if (dataType.isWildcardType()) {
                        throw new AptException((MessageResource)Message.DOMA4215, env, (Element)parameterElement, dataType.getQualifiedName());
                    }
                    return null;
                }
            }, null);
            iterationCallbackType.getTargetType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                    if (dataType.isRawType()) {
                        throw new AptException((MessageResource)Message.DOMA4216, env, (Element)parameterElement, dataType.getQualifiedName());
                    }
                    if (dataType.isWildcardType()) {
                        throw new AptException((MessageResource)Message.DOMA4217, env, (Element)parameterElement, dataType.getQualifiedName());
                    }
                    return null;
                }
            }, null);
            return iterationCallbackType;
        }
        ReferenceType referenceType = ReferenceType.newInstance(this.type, env);
        if (referenceType != null) {
            if (referenceType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4108, env, (Element)parameterElement, this.qualifiedName);
            }
            if (referenceType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4112, env, (Element)parameterElement, this.qualifiedName);
            }
            referenceType.getReferentType().accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                    if (dataType.isRawType()) {
                        throw new AptException((MessageResource)Message.DOMA4218, env, (Element)parameterElement, dataType.getQualifiedName());
                    }
                    if (dataType.isWildcardType()) {
                        throw new AptException((MessageResource)Message.DOMA4219, env, (Element)parameterElement, dataType.getQualifiedName());
                    }
                    return null;
                }
            }, null);
            return referenceType;
        }
        return AnyType.newInstance(this.type, env);
    }

    public VariableElement getElement() {
        return this.element;
    }

    public String getName() {
        return this.name;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isNullable() {
        return this.dataType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

            @Override
            public Boolean visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                return true;
            }
        }, null);
    }

    public boolean isBindable() {
        return this.dataType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

            @Override
            public Boolean visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitIterableType(IterableType dataType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitReferenceType(ReferenceType dataType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitAnyType(AnyType dataType, Void p) throws RuntimeException {
                return true;
            }
        }, null);
    }

    public boolean isAnnotated(Class<? extends Annotation> annotationType) {
        return this.element.getAnnotation(annotationType) != null;
    }
}

