/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.type.AbstractJdbcType;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class EnumType<E extends Enum<E>>
extends AbstractJdbcType<E> {
    protected final Class<E> enumClass;

    public EnumType(Class<E> enumClass) {
        super(12);
        if (enumClass == null) {
            throw new DomaNullPointerException("enumClass");
        }
        this.enumClass = enumClass;
    }

    @Override
    protected E doGetValue(ResultSet resultSet, int index) throws SQLException {
        String value = resultSet.getString(index);
        if (value == null) {
            return null;
        }
        try {
            return Enum.valueOf(this.enumClass, value);
        }
        catch (IllegalArgumentException e) {
            throw new JdbcException((MessageResource)Message.DOMA2040, this.enumClass.getName(), value);
        }
    }

    @Override
    protected void doSetValue(PreparedStatement preparedStatement, int index, E value) throws SQLException {
        preparedStatement.setString(index, ((Enum)value).name());
    }

    @Override
    protected E doGetValue(CallableStatement callableStatement, int index) throws SQLException {
        String value = callableStatement.getString(index);
        if (value == null) {
            return null;
        }
        try {
            return Enum.valueOf(this.enumClass, value);
        }
        catch (IllegalArgumentException e) {
            throw new JdbcException((MessageResource)Message.DOMA2040, this.enumClass.getName(), value);
        }
    }

    @Override
    protected String doConvertToLogFormat(E value) {
        return "'" + ((Enum)value).name() + "'";
    }
}

