/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.BindVariableNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.ParensNode;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.jdbc.sql.node.WordNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcUnsupportedOperationException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class BindVariableNode
extends AbstractSqlNode {
    protected final SqlLocation location;
    protected final String variableName;
    protected final String text;
    protected WordNode wordNode;
    protected ParensNode parensNode;

    public BindVariableNode(SqlLocation location, String variableName, String text) {
        AssertionUtil.assertNotNull((Object)location, (Object)variableName, (Object)text);
        this.location = location;
        this.variableName = variableName;
        this.text = text;
    }

    public SqlLocation getLocation() {
        return this.location;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public BindVariableNode copy() {
        BindVariableNode clone = new BindVariableNode(this.location, this.variableName, this.text);
        if (this.wordNode != null) {
            clone.wordNode = this.wordNode.copy();
        }
        if (this.parensNode != null) {
            clone.parensNode = this.parensNode.copy();
        }
        for (SqlNode child : this.children) {
            clone.addNode(child.copy());
        }
        return clone;
    }

    @Override
    public void addNode(SqlNode child) {
        throw new JdbcUnsupportedOperationException(this.getClass().getName(), "addNode");
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof BindVariableNodeVisitor) {
            BindVariableNodeVisitor v = (BindVariableNodeVisitor)visitor;
            return v.visitBindVariableNode(this, p);
        }
        return visitor.visitUnknownNode(this, p);
    }

    public WordNode getWordNode() {
        return this.wordNode;
    }

    public void setWordNode(WordNode wordNode) {
        this.wordNode = wordNode;
    }

    public ParensNode getParensNode() {
        return this.parensNode;
    }

    public void setParensNode(ParensNode parensNode) {
        this.parensNode = parensNode;
    }

    public boolean isWordNodeIgnored() {
        return this.wordNode != null;
    }

    public boolean isParensNodeIgnored() {
        return this.parensNode != null;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.getClass().getSimpleName());
        buf.append(" ");
        buf.append(this.text);
        for (SqlNode child : this.children) {
            buf.append(child);
        }
        if (this.wordNode != null) {
            buf.append(this.wordNode);
        } else if (this.parensNode != null) {
            buf.append(this.parensNode);
        }
        buf.append("]");
        return buf.toString();
    }
}

