/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.BigIntegerWrapperVisitor;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class BigIntegerWrapper
extends AbstractWrapper<BigInteger>
implements NumberWrapper<BigInteger> {
    public BigIntegerWrapper() {
    }

    public BigIntegerWrapper(BigInteger value) {
        super(value);
    }

    @Override
    public void set(Number v) {
        if (v instanceof BigInteger) {
            super.set((BigInteger)v);
        } else if (v instanceof BigDecimal) {
            super.set(((BigDecimal)v).toBigInteger());
        } else {
            super.set(BigInteger.valueOf(v.longValue()));
        }
    }

    @Override
    public void increment() {
        BigInteger value = this.getIncrementedValue();
        if (value != null) {
            this.doSet(value);
        }
    }

    @Override
    public void decrement() {
        BigInteger value = this.getDecrementedValue();
        if (value != null) {
            this.doSet(value);
        }
    }

    @Override
    public BigInteger getIncrementedValue() {
        BigInteger value = (BigInteger)this.doGet();
        if (value != null) {
            return value.add(BigInteger.ONE);
        }
        return null;
    }

    @Override
    public BigInteger getDecrementedValue() {
        BigInteger value = (BigInteger)this.doGet();
        if (value != null) {
            return value.subtract(BigInteger.ONE);
        }
        return null;
    }

    @Override
    public <R, P, TH extends Throwable> R accept(WrapperVisitor<R, P, TH> visitor, P p) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof BigIntegerWrapperVisitor) {
            BigIntegerWrapperVisitor v = (BigIntegerWrapperVisitor)visitor;
            return v.visitBigIntegerWrapper(this, p);
        }
        return visitor.visitUnknownWrapper(this, p);
    }
}

