/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.lang.reflect.Method;
import java.sql.Statement;
import java.util.ArrayList;
import org.seasar.doma.internal.jdbc.entity.AbstractPostInsertContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreInsertContext;
import org.seasar.doma.internal.jdbc.query.AutoBatchModifyQuery;
import org.seasar.doma.internal.jdbc.query.BatchInsertQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.GeneratedIdPropertyType;
import org.seasar.doma.jdbc.id.IdGenerationConfig;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class AutoBatchInsertQuery<E>
extends AutoBatchModifyQuery<E>
implements BatchInsertQuery {
    protected GeneratedIdPropertyType<? super E, E, ?, ?> generatedIdPropertyType;
    protected IdGenerationConfig idGenerationConfig;
    protected boolean batchSupported = true;

    public AutoBatchInsertQuery(EntityType<E> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.method, this.config, this.callerClassName, this.callerMethodName, this.entities, this.sqls);
        int size = this.entities.size();
        if (size == 0) {
            return;
        }
        this.executable = true;
        this.executionSkipCause = null;
        this.currentEntity = this.entities.get(0);
        this.preInsert();
        this.prepareIdAndVersionPropertyTypes();
        this.prepareOptions();
        this.prepareTargetPropertyTypes();
        this.prepareIdValue();
        this.prepareVersionValue();
        this.prepareSql();
        this.entities.set(0, this.currentEntity);
        for (int i = 1; i < size; ++i) {
            this.currentEntity = this.entities.get(i);
            this.preInsert();
            this.prepareIdValue();
            this.prepareVersionValue();
            this.prepareSql();
            this.entities.set(i, this.currentEntity);
        }
        this.currentEntity = null;
        AssertionUtil.assertEquals(this.entities.size(), this.sqls.size());
    }

    protected void preInsert() {
        AutoBatchPreInsertContext context = new AutoBatchPreInsertContext(this.entityType, this.method, this.config);
        this.entityType.preInsert(this.currentEntity, context);
        if (context.getNewEntity() != null) {
            this.currentEntity = context.getNewEntity();
        }
    }

    @Override
    protected void prepareIdAndVersionPropertyTypes() {
        super.prepareIdAndVersionPropertyTypes();
        this.generatedIdPropertyType = this.entityType.getGeneratedIdPropertyType();
        if (this.generatedIdPropertyType != null && this.idGenerationConfig == null) {
            this.idGenerationConfig = new IdGenerationConfig(this.config, this.entityType);
            this.generatedIdPropertyType.validateGenerationStrategy(this.idGenerationConfig);
            this.autoGeneratedKeysSupported = this.generatedIdPropertyType.isAutoGeneratedKeysSupported(this.idGenerationConfig);
            this.batchSupported = this.generatedIdPropertyType.isBatchSupported(this.idGenerationConfig);
        }
    }

    protected void prepareTargetPropertyTypes() {
        this.targetPropertyTypes = new ArrayList(this.entityType.getEntityPropertyTypes().size());
        for (EntityPropertyType<Object, ?> entityPropertyType : this.entityType.getEntityPropertyTypes()) {
            if (!entityPropertyType.isInsertable()) continue;
            if (entityPropertyType.isId()) {
                if (entityPropertyType != this.generatedIdPropertyType || this.generatedIdPropertyType.isIncluded(this.idGenerationConfig)) {
                    this.targetPropertyTypes.add(entityPropertyType);
                }
                if (this.generatedIdPropertyType != null || entityPropertyType.getWrapper(this.currentEntity).get() != null) continue;
                throw new JdbcException((MessageResource)Message.DOMA2020, this.entityType.getName(), entityPropertyType.getName());
            }
            if (!this.isTargetPropertyName(entityPropertyType.getName())) continue;
            this.targetPropertyTypes.add(entityPropertyType);
        }
    }

    protected void prepareIdValue() {
        if (this.generatedIdPropertyType != null && this.idGenerationConfig != null) {
            if (this.entityType.isImmutable()) {
                Object newEntity = this.generatedIdPropertyType.preInsertAndNewEntity(this.currentEntity, this.idGenerationConfig, this.entityType);
                if (newEntity != null) {
                    this.currentEntity = newEntity;
                }
            } else {
                this.generatedIdPropertyType.preInsert(this.currentEntity, this.idGenerationConfig);
            }
        }
    }

    protected void prepareVersionValue() {
        if (this.versionPropertyType != null) {
            if (this.entityType.isImmutable()) {
                Object newEntity = this.versionPropertyType.setIfNecessaryAndMakeNewEntity(this.currentEntity, 1, this.entityType);
                if (newEntity != null) {
                    this.currentEntity = newEntity;
                }
            } else {
                this.versionPropertyType.setIfNecessary(this.currentEntity, 1);
            }
        }
    }

    protected void prepareSql() {
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.BATCH_INSERT);
        builder.appendSql("insert into ");
        builder.appendSql(this.entityType.getQualifiedTableName());
        builder.appendSql(" (");
        for (EntityPropertyType p : this.targetPropertyTypes) {
            builder.appendSql(p.getColumnName());
            builder.appendSql(", ");
        }
        builder.cutBackSql(2);
        builder.appendSql(") values (");
        for (EntityPropertyType p : this.targetPropertyTypes) {
            builder.appendWrapper(p.getWrapper(this.currentEntity));
            builder.appendSql(", ");
        }
        builder.cutBackSql(2);
        builder.appendSql(")");
        PreparedSql sql = builder.build();
        this.sqls.add(sql);
    }

    @Override
    public boolean isBatchSupported() {
        return this.batchSupported;
    }

    @Override
    public void generateId(Statement statement, int index) {
        if (this.generatedIdPropertyType != null && this.idGenerationConfig != null) {
            if (this.entityType.isImmutable()) {
                E newEntity = this.generatedIdPropertyType.postInsertAndNewEntity(this.entities.get(index), this.idGenerationConfig, statement, this.entityType);
                if (newEntity != null) {
                    this.entities.set(index, newEntity);
                }
            } else {
                this.generatedIdPropertyType.postInsert(this.entities.get(index), this.idGenerationConfig, statement);
            }
        }
    }

    @Override
    public void complete() {
        int len = this.entities.size();
        for (int i = 0; i < len; ++i) {
            this.currentEntity = this.entities.get(i);
            this.postInsert();
            this.entities.set(i, this.currentEntity);
        }
    }

    protected void postInsert() {
        AutoBatchPostInsertContext context = new AutoBatchPostInsertContext(this.entityType, this.method, this.config);
        this.entityType.postInsert(this.currentEntity, context);
        if (context.getNewEntity() != null) {
            this.currentEntity = context.getNewEntity();
        }
    }

    protected static class AutoBatchPostInsertContext<E>
    extends AbstractPostInsertContext<E> {
        public AutoBatchPostInsertContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected static class AutoBatchPreInsertContext<E>
    extends AbstractPreInsertContext<E> {
        public AutoBatchPreInsertContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }
}

