/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr.node;

import java.util.ArrayList;
import java.util.List;
import org.seasar.doma.internal.expr.node.ExpressionLocation;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.expr.node.ExpressionNodeVisitor;
import org.seasar.doma.internal.expr.node.OperatorNode;
import org.seasar.doma.internal.util.AssertionUtil;

public class CommaOperatorNode
implements OperatorNode {
    protected static final int PRIORITY = 0;
    protected final List<ExpressionNode> expressionNodes = new ArrayList<ExpressionNode>();
    protected final ExpressionLocation location;
    protected final String expression;

    public CommaOperatorNode(ExpressionLocation location, String expression) {
        AssertionUtil.assertNotNull((Object)location, (Object)expression);
        this.location = location;
        this.expression = expression;
    }

    public void addNode(ExpressionNode expressionNode) {
        this.expressionNodes.add(expressionNode);
    }

    public List<ExpressionNode> getNodes() {
        return this.expressionNodes;
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public <R, P> R accept(ExpressionNodeVisitor<R, P> visitor, P p) {
        return visitor.visitCommaOperatorNode(this, p);
    }

    @Override
    public ExpressionLocation getLocation() {
        return this.location;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (ExpressionNode node : this.expressionNodes) {
            buf.append(node.toString());
            buf.append(this.expression);
            buf.append(" ");
        }
        if (buf.length() > 2) {
            buf.setLength(buf.length() - (this.expression.length() + 1));
        }
        return buf.toString();
    }
}

