/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.expr;

import java.math.BigDecimal;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.seasar.doma.internal.expr.ExpressionException;
import org.seasar.doma.internal.expr.ExpressionReducer;
import org.seasar.doma.internal.expr.ExpressionTokenType;
import org.seasar.doma.internal.expr.ExpressionTokenizer;
import org.seasar.doma.internal.expr.node.AddOperatorNode;
import org.seasar.doma.internal.expr.node.AndOperatorNode;
import org.seasar.doma.internal.expr.node.CommaOperatorNode;
import org.seasar.doma.internal.expr.node.DivideOperatorNode;
import org.seasar.doma.internal.expr.node.EmptyNode;
import org.seasar.doma.internal.expr.node.EqOperatorNode;
import org.seasar.doma.internal.expr.node.ExpressionLocation;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.expr.node.FieldOperatorNode;
import org.seasar.doma.internal.expr.node.FunctionOperatorNode;
import org.seasar.doma.internal.expr.node.GeOperatorNode;
import org.seasar.doma.internal.expr.node.GtOperatorNode;
import org.seasar.doma.internal.expr.node.LeOperatorNode;
import org.seasar.doma.internal.expr.node.LiteralNode;
import org.seasar.doma.internal.expr.node.LtOperatorNode;
import org.seasar.doma.internal.expr.node.MethodOperatorNode;
import org.seasar.doma.internal.expr.node.ModOperatorNode;
import org.seasar.doma.internal.expr.node.MultiplyOperatorNode;
import org.seasar.doma.internal.expr.node.NeOperatorNode;
import org.seasar.doma.internal.expr.node.NewOperatorNode;
import org.seasar.doma.internal.expr.node.NotOperatorNode;
import org.seasar.doma.internal.expr.node.OperatorNode;
import org.seasar.doma.internal.expr.node.OrOperatorNode;
import org.seasar.doma.internal.expr.node.ParensNode;
import org.seasar.doma.internal.expr.node.StaticFieldOperatorNode;
import org.seasar.doma.internal.expr.node.StaticMethodOperatorNode;
import org.seasar.doma.internal.expr.node.SubtractOperatorNode;
import org.seasar.doma.internal.expr.node.VariableNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;

public class ExpressionParser {
    protected final Deque<ExpressionNode> expressionNodes = new LinkedList<ExpressionNode>();
    protected final Deque<OperatorNode> operatorNodes = new LinkedList<OperatorNode>();
    protected final ExpressionReducer expressionReducer = new ExpressionReducer();
    protected final String expression;
    protected final String originalExpression;
    protected final int startPosition;
    protected final ExpressionTokenizer tokenizer;
    protected ExpressionTokenType tokenType;
    protected String token;

    public ExpressionParser(String expression) {
        this(expression, expression, 0);
    }

    protected ExpressionParser(String expression, String originalExpression, int startPosition) {
        AssertionUtil.assertNotNull((Object)expression, (Object)originalExpression);
        this.expression = expression;
        this.originalExpression = originalExpression;
        this.startPosition = startPosition;
        this.tokenizer = new ExpressionTokenizer(expression);
    }

    public ExpressionNode parse() {
        block39: while (true) {
            this.tokenType = this.tokenizer.next();
            this.token = this.tokenizer.getToken();
            switch (this.tokenType) {
                case VARIABLE: {
                    this.parseVariable();
                    continue block39;
                }
                case OPENED_PARENS: {
                    this.parseOpenedParens();
                    continue block39;
                }
                case CLOSED_PARENS: {
                    break block39;
                }
                case CHAR_LITERAL: {
                    this.parseCharLiteral();
                    continue block39;
                }
                case STRING_LITERAL: {
                    this.parseStringLiteral();
                    continue block39;
                }
                case INT_LITERAL: {
                    this.parseIntLiteral();
                    continue block39;
                }
                case LONG_LITERAL: {
                    this.parseLongLiteral();
                    continue block39;
                }
                case FLOAT_LITERAL: {
                    this.parseFloatLiteral();
                    continue block39;
                }
                case DOUBLE_LITERAL: {
                    this.parseDoubleLiteral();
                    continue block39;
                }
                case BIGDECIMAL_LITERAL: {
                    this.parseBigDecimalLiteral();
                    continue block39;
                }
                case ILLEGAL_NUMBER_LITERAL: {
                    ExpressionLocation location = this.getLocation();
                    throw new ExpressionException(Message.DOMA3012, location.getExpression(), location.getPosition(), this.token);
                }
                case TRUE_LITERAL: {
                    this.parseTrueLiteral();
                    continue block39;
                }
                case FALSE_LITERAL: {
                    this.parseFalseLiteral();
                    continue block39;
                }
                case NULL_LITERAL: {
                    this.parseNullLiteral();
                    continue block39;
                }
                case NOT_OPERATOR: {
                    this.parseOperator(new NotOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case AND_OPERATOR: {
                    this.parseOperator(new AndOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case OR_OPERATOR: {
                    this.parseOperator(new OrOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case ADD_OPERATOR: {
                    this.parseOperator(new AddOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case SUBTRACT_OPERATOR: {
                    this.parseOperator(new SubtractOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case MULTIPLY_OPERATOR: {
                    this.parseOperator(new MultiplyOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case DIVIDE_OPERATOR: {
                    this.parseOperator(new DivideOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case MOD_OPERATOR: {
                    this.parseOperator(new ModOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case COMMA_OPERATOR: {
                    this.parseOperator(new CommaOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case EQ_OPERATOR: {
                    this.parseOperator(new EqOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case NE_OPERATOR: {
                    this.parseOperator(new NeOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case GE_OPERATOR: {
                    this.parseOperator(new GeOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case LE_OPERATOR: {
                    this.parseOperator(new LeOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case GT_OPERATOR: {
                    this.parseOperator(new GtOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case LT_OPERATOR: {
                    this.parseOperator(new LtOperatorNode(this.getLocation(), this.token));
                    continue block39;
                }
                case NEW_OPERATOR: {
                    this.parseNewOperand();
                    continue block39;
                }
                case METHOD_OPERATOR: {
                    this.parseMethodOperand();
                    continue block39;
                }
                case STATIC_METHOD_OPERATOR: {
                    this.parseStaticMethodOperand();
                    continue block39;
                }
                case FUNCTION_OPERATOR: {
                    this.parseFunctionOperand();
                    continue block39;
                }
                case FIELD_OPERATOR: {
                    this.parseFieldOperand();
                    continue block39;
                }
                case STATIC_FIELD_OPERATOR: {
                    this.parseStaticFieldOperand();
                    continue block39;
                }
                case OTHER: {
                    ExpressionLocation location = this.getLocation();
                    throw new ExpressionException(Message.DOMA3011, location.getExpression(), location.getPosition(), this.token);
                }
                case EOE: {
                    break block39;
                }
                default: {
                    continue block39;
                }
            }
            break;
        }
        this.reduceAll();
        if (this.expressionNodes.isEmpty()) {
            return new EmptyNode(this.getLocation());
        }
        return this.expressionNodes.pop();
    }

    protected void parseVariable() {
        VariableNode node = new VariableNode(this.getLocation(), this.token);
        this.expressionNodes.push(node);
    }

    protected void parseOpenedParens() {
        int start = this.tokenizer.getPosition();
        String subExpression = this.expression.substring(start);
        ExpressionParser parser = new ExpressionParser(subExpression, this.originalExpression, start);
        ExpressionNode childExpressionNode = parser.parse();
        if (parser.tokenType != ExpressionTokenType.CLOSED_PARENS) {
            ExpressionLocation location = this.getLocation();
            throw new ExpressionException(Message.DOMA3026, location.getExpression(), location.getPosition());
        }
        int end = start + parser.tokenizer.getPosition();
        this.tokenizer.setPosition(end, true);
        ParensNode node = new ParensNode(this.getLocation(), childExpressionNode);
        this.expressionNodes.push(node);
    }

    protected void parseClosedParens() {
        this.reduceAll();
    }

    protected void parseStringLiteral() {
        String value = this.token.substring(1, this.token.length() - 1);
        LiteralNode node = new LiteralNode(this.getLocation(), this.token, value, String.class);
        this.expressionNodes.push(node);
    }

    protected void parseCharLiteral() {
        char value = this.token.charAt(1);
        LiteralNode node = new LiteralNode(this.getLocation(), this.token, Character.valueOf(value), Character.TYPE);
        this.expressionNodes.push(node);
    }

    protected void parseIntLiteral() {
        int start = this.token.charAt(0) == '+' ? 1 : 0;
        int end = this.token.length();
        Integer value = Integer.valueOf(this.token.substring(start, end));
        LiteralNode node = new LiteralNode(this.getLocation(), this.token, value, Integer.TYPE);
        this.expressionNodes.push(node);
    }

    protected void parseLongLiteral() {
        int start = this.token.charAt(0) == '+' ? 1 : 0;
        int end = this.token.length() - 1;
        Long value = Long.valueOf(this.token.substring(start, end));
        LiteralNode node = new LiteralNode(this.getLocation(), this.token, value, Long.TYPE);
        this.expressionNodes.push(node);
    }

    protected void parseFloatLiteral() {
        int start = this.token.charAt(0) == '+' ? 1 : 0;
        int end = this.token.length() - 1;
        Float value = Float.valueOf(this.token.substring(start, end));
        LiteralNode node = new LiteralNode(this.getLocation(), this.token, value, Float.TYPE);
        this.expressionNodes.push(node);
    }

    protected void parseDoubleLiteral() {
        int start = this.token.charAt(0) == '+' ? 1 : 0;
        int end = this.token.length() - 1;
        Double value = Double.valueOf(this.token.substring(start, end));
        LiteralNode node = new LiteralNode(this.getLocation(), this.token, value, Double.TYPE);
        this.expressionNodes.push(node);
    }

    protected void parseBigDecimalLiteral() {
        int start = 0;
        int end = this.token.length() - 1;
        BigDecimal value = new BigDecimal(this.token.substring(start, end));
        LiteralNode node = new LiteralNode(this.getLocation(), this.token, value, BigDecimal.class);
        this.expressionNodes.push(node);
    }

    protected void parseTrueLiteral() {
        LiteralNode node = new LiteralNode(this.getLocation(), this.token, true, Boolean.TYPE);
        this.expressionNodes.push(node);
    }

    protected void parseFalseLiteral() {
        LiteralNode node = new LiteralNode(this.getLocation(), this.token, false, Boolean.TYPE);
        this.expressionNodes.push(node);
    }

    protected void parseNullLiteral() {
        LiteralNode node = new LiteralNode(this.getLocation(), this.token, null, Void.TYPE);
        this.expressionNodes.push(node);
    }

    protected void parseMethodOperand() {
        String name = this.token.substring(1);
        MethodOperatorNode node = new MethodOperatorNode(this.getLocation(), this.token, name);
        this.tokenType = this.tokenizer.next();
        AssertionUtil.assertEquals(ExpressionTokenType.OPENED_PARENS, this.tokenType);
        this.parseOpenedParens();
        this.reduce(node);
    }

    protected void parseStaticMethodOperand() {
        int pos = this.token.lastIndexOf(64);
        AssertionUtil.assertTrue(pos > -1, new Object[0]);
        String className = this.token.substring(1, pos);
        String methodName = this.token.substring(pos + 1);
        StaticMethodOperatorNode node = new StaticMethodOperatorNode(this.getLocation(), this.token, className, methodName);
        this.tokenType = this.tokenizer.next();
        AssertionUtil.assertEquals(ExpressionTokenType.OPENED_PARENS, this.tokenType);
        this.parseOpenedParens();
        this.reduce(node);
    }

    protected void parseFunctionOperand() {
        String name = this.token.substring(1);
        FunctionOperatorNode node = new FunctionOperatorNode(this.getLocation(), this.token, name);
        this.tokenType = this.tokenizer.next();
        AssertionUtil.assertEquals(ExpressionTokenType.OPENED_PARENS, this.tokenType);
        this.parseOpenedParens();
        this.reduce(node);
    }

    protected void parseFieldOperand() {
        String name = this.token.substring(1);
        FieldOperatorNode node = new FieldOperatorNode(this.getLocation(), this.token, name);
        this.reduce(node);
    }

    protected void parseStaticFieldOperand() {
        int pos = this.token.lastIndexOf(64);
        AssertionUtil.assertTrue(pos > -1, new Object[0]);
        String className = this.token.substring(1, pos);
        String fieldName = this.token.substring(pos + 1);
        StaticFieldOperatorNode node = new StaticFieldOperatorNode(this.getLocation(), this.token, className, fieldName);
        this.reduce(node);
    }

    protected void parseNewOperand() {
        StringBuilder buf = new StringBuilder();
        while (this.tokenizer.next() != ExpressionTokenType.OPENED_PARENS) {
            if (this.tokenType == ExpressionTokenType.WHITESPACE) continue;
            buf.append(this.tokenizer.getToken());
        }
        NewOperatorNode node = new NewOperatorNode(this.getLocation(), this.token, buf.toString().trim());
        this.parseOpenedParens();
        this.reduce(node);
    }

    protected void parseOperator(OperatorNode currentNode) {
        if (this.operatorNodes.peek() == null) {
            this.operatorNodes.push(currentNode);
        } else if (currentNode.getPriority() > this.operatorNodes.peek().getPriority()) {
            this.operatorNodes.push(currentNode);
        } else {
            Iterator<OperatorNode> it = this.operatorNodes.iterator();
            while (it.hasNext()) {
                OperatorNode operatorNode = it.next();
                if (operatorNode.getPriority() <= currentNode.getPriority()) continue;
                this.reduce(operatorNode);
                it.remove();
            }
            this.operatorNodes.push(currentNode);
        }
    }

    protected void reduceAll() {
        Iterator<OperatorNode> it = this.operatorNodes.iterator();
        while (it.hasNext()) {
            OperatorNode operator = it.next();
            this.reduce(operator);
            it.remove();
        }
    }

    protected void reduce(OperatorNode operator) {
        this.expressionReducer.reduce(operator, this.expressionNodes);
        this.expressionNodes.push(operator);
    }

    protected ExpressionLocation getLocation() {
        return new ExpressionLocation(this.originalExpression, this.startPosition + this.tokenizer.getPosition());
    }
}

