/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import org.seasar.doma.BatchUpdate;
import org.seasar.doma.internal.apt.mirror.BatchModifyMirror;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class BatchUpdateMirror
extends BatchModifyMirror {
    protected BatchUpdateMirror(AnnotationMirror annotationMirror) {
        super(annotationMirror);
    }

    public static BatchUpdateMirror newInstance(ExecutableElement method, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror(method, BatchUpdate.class, env);
        if (annotationMirror == null) {
            return null;
        }
        BatchUpdateMirror result = new BatchUpdateMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("sqlFile".equals(name)) {
                result.sqlFile = value;
                continue;
            }
            if ("queryTimeout".equals(name)) {
                result.queryTimeout = value;
                continue;
            }
            if ("batchSize".equals(name)) {
                result.batchSize = value;
                continue;
            }
            if ("includeVersion".equals(name)) {
                result.includeVersion = value;
                continue;
            }
            if ("ignoreVersion".equals(name)) {
                result.ignoreVersion = value;
                continue;
            }
            if ("suppressOptimisticLockException".equals(name)) {
                result.suppressOptimisticLockException = value;
                continue;
            }
            if ("include".equals(name)) {
                result.include = value;
                continue;
            }
            if (!"exclude".equals(name)) continue;
            result.exclude = value;
        }
        return result;
    }
}

