/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.decl;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.decl.TypeDeclaration;
import org.seasar.doma.internal.apt.decl.TypeParameterDeclaration;
import org.seasar.doma.internal.util.AssertionUtil;

public class MethodDeclaration {
    protected ExecutableElement element;
    protected List<TypeParameterDeclaration> typeParameterDeclarations;
    protected ProcessingEnvironment env;

    protected MethodDeclaration() {
    }

    public ExecutableElement getElement() {
        return this.element;
    }

    public TypeDeclaration getReturnTypeDeclaration() {
        TypeMirror returnType = this.resolveTypeParameter(this.element.getReturnType());
        return TypeDeclaration.newTypeDeclaration(returnType, this.env);
    }

    public boolean isStatic() {
        return this.element.getModifiers().contains((Object)Modifier.STATIC);
    }

    protected TypeMirror resolveTypeParameter(TypeMirror formalType) {
        for (TypeParameterDeclaration typeParameterDecl : this.typeParameterDeclarations) {
            if (!((Object)formalType).equals(typeParameterDecl.getFormalType())) continue;
            return typeParameterDecl.getActualType();
        }
        return formalType;
    }

    public static MethodDeclaration newInstance(ExecutableElement methodElement, List<TypeParameterDeclaration> typeParameterDeclarations, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)methodElement, typeParameterDeclarations, (Object)env);
        AssertionUtil.assertTrue(methodElement.getKind() == ElementKind.METHOD, new Object[0]);
        MethodDeclaration methodDeclaration = new MethodDeclaration();
        methodDeclaration.element = methodElement;
        methodDeclaration.typeParameterDeclarations = typeParameterDeclarations;
        methodDeclaration.env = env;
        return methodDeclaration;
    }
}

