/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import java.util.HashMap;
import java.util.Map;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.OtherNodeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcUnsupportedOperationException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class OtherNode
extends AbstractSqlNode {
    protected static final Map<String, OtherNode> otherNodeMap = new HashMap<String, OtherNode>();
    protected final String other;

    private OtherNode(String other) {
        AssertionUtil.assertNotNull(other);
        this.other = other;
    }

    public String getOther() {
        return this.other;
    }

    @Override
    public void addNode(SqlNode child) {
        throw new JdbcUnsupportedOperationException(this.getClass().getName(), "addNode");
    }

    @Override
    public OtherNode copy() {
        return this;
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof OtherNodeVisitor) {
            OtherNodeVisitor v = (OtherNodeVisitor)visitor;
            return v.visitOtherNode(this, p);
        }
        return visitor.visitUnknownNode(this, p);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.getClass().getSimpleName());
        buf.append(" ");
        buf.append(this.other);
        buf.append("]");
        return buf.toString();
    }

    public static OtherNode of(String other) {
        OtherNode otherNode = otherNodeMap.get(other);
        if (otherNode != null) {
            return otherNode;
        }
        return new OtherNode(other);
    }

    static {
        otherNodeMap.put(",", new OtherNode(","));
        otherNodeMap.put("=", new OtherNode("="));
        otherNodeMap.put(">", new OtherNode(">"));
        otherNodeMap.put("<", new OtherNode("<"));
        otherNodeMap.put("-", new OtherNode("-"));
        otherNodeMap.put("+", new OtherNode("+"));
        otherNodeMap.put("*", new OtherNode("*"));
        otherNodeMap.put("/", new OtherNode("/"));
        otherNodeMap.put("(", new OtherNode("("));
        otherNodeMap.put(")", new OtherNode(")"));
        otherNodeMap.put(";", new OtherNode(";"));
    }
}

