/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.TableGenerator;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class TableGeneratorMirror {
    protected final AnnotationMirror annotationMirror;
    protected AnnotationValue catalog;
    protected AnnotationValue schema;
    protected AnnotationValue table;
    protected AnnotationValue pkColumnName;
    protected AnnotationValue valueColumnName;
    protected AnnotationValue pkColumnValue;
    protected AnnotationValue initialValue;
    protected AnnotationValue allocationSize;
    protected AnnotationValue implementer;

    protected TableGeneratorMirror(AnnotationMirror annotationMirror) {
        AssertionUtil.assertNotNull(annotationMirror);
        this.annotationMirror = annotationMirror;
    }

    public static TableGeneratorMirror newInstance(VariableElement field, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror(field, TableGenerator.class, env);
        if (annotationMirror == null) {
            return null;
        }
        TableGeneratorMirror result = new TableGeneratorMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("catalog".equals(name)) {
                result.catalog = value;
                continue;
            }
            if ("schema".equals(name)) {
                result.schema = value;
                continue;
            }
            if ("table".equals(name)) {
                result.table = value;
                continue;
            }
            if ("pkColumnName".equals(name)) {
                result.pkColumnName = value;
                continue;
            }
            if ("valueColumnName".equals(name)) {
                result.valueColumnName = value;
                continue;
            }
            if ("pkColumnValue".equals(name)) {
                result.pkColumnValue = value;
                continue;
            }
            if ("initialValue".equals(name)) {
                result.initialValue = value;
                continue;
            }
            if ("allocationSize".equals(name)) {
                result.allocationSize = value;
                continue;
            }
            if (!"implementer".equals(name)) continue;
            result.implementer = value;
        }
        return result;
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public AnnotationValue getCatalog() {
        return this.catalog;
    }

    public AnnotationValue getSchema() {
        return this.schema;
    }

    public AnnotationValue getTable() {
        return this.table;
    }

    public AnnotationValue getPkColumnName() {
        return this.pkColumnName;
    }

    public AnnotationValue getValueColumnName() {
        return this.valueColumnName;
    }

    public AnnotationValue getPkColumnValue() {
        return this.pkColumnValue;
    }

    public AnnotationValue getInitialValue() {
        return this.initialValue;
    }

    public AnnotationValue getAllocationSize() {
        return this.allocationSize;
    }

    public AnnotationValue getImplementer() {
        return this.implementer;
    }

    public String getCatalogValue() {
        String value = AnnotationValueUtil.toString(this.catalog);
        if (value == null) {
            throw new AptIllegalStateException("catalog");
        }
        return value;
    }

    public String getSchemaValue() {
        String value = AnnotationValueUtil.toString(this.schema);
        if (value == null) {
            throw new AptIllegalStateException("schema");
        }
        return value;
    }

    public String getTableValue() {
        String value = AnnotationValueUtil.toString(this.table);
        if (value == null) {
            throw new AptIllegalStateException("table");
        }
        return value;
    }

    public String getPkColumnNameValue() {
        String value = AnnotationValueUtil.toString(this.pkColumnName);
        if (value == null) {
            throw new AptIllegalStateException("pkColumnName");
        }
        return value;
    }

    public String getValueColumnNameValue() {
        String value = AnnotationValueUtil.toString(this.valueColumnName);
        if (value == null) {
            throw new AptIllegalStateException("valueColumnName");
        }
        return value;
    }

    public String getPkColumnValueValue() {
        String value = AnnotationValueUtil.toString(this.pkColumnValue);
        if (value == null) {
            throw new AptIllegalStateException("pkColumnValue");
        }
        return value;
    }

    public Long getInitialValueValue() {
        Long value = AnnotationValueUtil.toLong(this.initialValue);
        if (value == null) {
            throw new AptIllegalStateException("initialValue");
        }
        return value;
    }

    public Long getAllocationSizeValue() {
        Long value = AnnotationValueUtil.toLong(this.allocationSize);
        if (value == null) {
            throw new AptIllegalStateException("allocationSize");
        }
        return value;
    }

    public TypeMirror getImplementerValue() {
        TypeMirror value = AnnotationValueUtil.toType(this.implementer);
        if (value == null) {
            throw new AptIllegalStateException("implementer");
        }
        return value;
    }
}

