/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.sql.SQLException;
import java.util.Collections;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.jdbc.dialect.SqlitePagingTransformer;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.SqlLogFormattingVisitor;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.dialect.StandardDialect;

public class SqliteDialect
extends StandardDialect {
    public SqliteDialect() {
        this(new SqliteJdbcMappingVisitor(), new SqliteSqlLogFormattingVisitor(), new SqliteExpressionFunctions());
    }

    public SqliteDialect(JdbcMappingVisitor jdbcMappingVisitor) {
        this(jdbcMappingVisitor, new SqliteSqlLogFormattingVisitor(), new SqliteExpressionFunctions());
    }

    public SqliteDialect(SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(new SqliteJdbcMappingVisitor(), sqlLogFormattingVisitor, new SqliteExpressionFunctions());
    }

    public SqliteDialect(ExpressionFunctions expressionFunctions) {
        this(new SqliteJdbcMappingVisitor(), new SqliteSqlLogFormattingVisitor(), expressionFunctions);
    }

    public SqliteDialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(jdbcMappingVisitor, sqlLogFormattingVisitor, new SqliteExpressionFunctions());
    }

    public SqliteDialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor, ExpressionFunctions expressionFunctions) {
        super(jdbcMappingVisitor, sqlLogFormattingVisitor, expressionFunctions);
    }

    @Override
    public String getName() {
        return "sqlite";
    }

    @Override
    public boolean includesIdentityColumn() {
        return true;
    }

    @Override
    public PreparedSql getIdentitySelectSql(String qualifiedTableName, String columnName) {
        if (qualifiedTableName == null) {
            throw new DomaNullPointerException("qualifiedTableName");
        }
        if (columnName == null) {
            throw new DomaNullPointerException("columnName");
        }
        String rawSql = "select last_insert_rowid()";
        return new PreparedSql(SqlKind.SELECT, rawSql, rawSql, null, Collections.emptyList());
    }

    @Override
    protected SqlNode toPagingSqlNode(SqlNode sqlNode, long offset, long limit) {
        SqlitePagingTransformer transformer = new SqlitePagingTransformer(offset, limit);
        return transformer.transform(sqlNode);
    }

    @Override
    protected SqlNode toForUpdateSqlNode(SqlNode sqlNode, SelectForUpdateType forUpdateType, int waitSeconds, String ... aliases) {
        return sqlNode;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean isUniqueConstraintViolated(SQLException sqlException) {
        if (sqlException == null) {
            throw new DomaNullPointerException("sqlException");
        }
        SQLException cause = this.getCauseSQLException(sqlException);
        String message = cause.getMessage();
        return message != null && message.startsWith("[SQLITE_CONSTRAINT]") && message.contains(" unique)");
    }

    public static class SqliteExpressionFunctions
    extends StandardDialect.StandardExpressionFunctions {
    }

    public static class SqliteSqlLogFormattingVisitor
    extends StandardDialect.StandardSqlLogFormattingVisitor {
    }

    public static class SqliteJdbcMappingVisitor
    extends StandardDialect.StandardJdbcMappingVisitor {
    }
}

