/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.util.ArrayList;
import org.h2.command.dml.Query;
import org.h2.command.dml.SelectUnion;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.ViewCursor;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableView;
import org.h2.util.IntArray;
import org.h2.util.New;
import org.h2.util.SmallLRUCache;
import org.h2.util.SynchronizedVerifier;
import org.h2.util.Utils;
import org.h2.value.Value;

public class ViewIndex
extends BaseIndex {
    private final TableView view;
    private final String querySQL;
    private final ArrayList<Parameter> originalParameters;
    private final SmallLRUCache<IntArray, CostElement> costCache = SmallLRUCache.newInstance(64);
    private boolean recursive;
    private final int[] indexMasks;
    private String planSQL;
    private Query query;
    private final Session createSession;

    public ViewIndex(TableView tableView, String string, ArrayList<Parameter> arrayList, boolean bl) {
        this.initBaseIndex(tableView, 0, null, null, IndexType.createNonUnique(false));
        this.view = tableView;
        this.querySQL = string;
        this.originalParameters = arrayList;
        this.recursive = bl;
        this.columns = new Column[0];
        this.createSession = null;
        this.indexMasks = null;
    }

    public ViewIndex(TableView tableView, ViewIndex viewIndex, Session session, int[] nArray) {
        this.initBaseIndex(tableView, 0, null, null, IndexType.createNonUnique(false));
        this.view = tableView;
        this.querySQL = viewIndex.querySQL;
        this.originalParameters = viewIndex.originalParameters;
        this.recursive = viewIndex.recursive;
        this.indexMasks = nArray;
        this.createSession = session;
        this.columns = new Column[0];
        if (!this.recursive) {
            this.query = this.getQuery(session, nArray);
            this.planSQL = this.query.getPlanSQL();
        }
    }

    public Session getSession() {
        return this.createSession;
    }

    @Override
    public String getPlanSQL() {
        return this.planSQL;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void remove(Session session, Row row) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public synchronized double getCost(Session session, int[] nArray) {
        long l;
        if (this.recursive) {
            return 1000.0;
        }
        IntArray intArray = new IntArray(nArray == null ? Utils.EMPTY_INT_ARRAY : nArray);
        SynchronizedVerifier.check(this.costCache);
        CostElement costElement = (CostElement)this.costCache.get(intArray);
        if (costElement != null && (l = System.currentTimeMillis()) < costElement.evaluatedAt + 10000L) {
            return costElement.cost;
        }
        Query query = (Query)session.prepare(this.querySQL, true);
        if (nArray != null) {
            int n;
            int n2;
            IntArray intArray2 = new IntArray();
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2];
                if (n == 0) continue;
                intArray2.add(n2);
            }
            n2 = intArray2.size();
            for (n = 0; n < n2; ++n) {
                Parameter parameter;
                int n3 = intArray2.get(n);
                int n4 = nArray[n3];
                int n5 = query.getParameters().size() + this.view.getParameterOffset();
                if ((n4 & 1) != 0) {
                    parameter = new Parameter(n5);
                    query.addGlobalCondition(parameter, n3, 16);
                    continue;
                }
                if ((n4 & 2) != 0) {
                    parameter = new Parameter(n5);
                    query.addGlobalCondition(parameter, n3, 1);
                }
                if ((n4 & 4) == 0) continue;
                parameter = new Parameter(n5);
                query.addGlobalCondition(parameter, n3, 3);
            }
            String string = query.getPlanSQL();
            query = (Query)session.prepare(string, true);
        }
        double d = query.getCost();
        costElement = new CostElement();
        costElement.evaluatedAt = System.currentTimeMillis();
        costElement.cost = d;
        this.costCache.put(intArray, costElement);
        return d;
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        int n;
        int n2;
        if (this.recursive) {
            ResultInterface resultInterface = this.view.getRecursiveResult();
            if (resultInterface != null) {
                resultInterface.reset();
                return new ViewCursor(this, resultInterface, searchRow, searchRow2);
            }
            if (this.query == null) {
                this.query = (Query)this.createSession.prepare(this.querySQL, true);
                this.planSQL = this.query.getPlanSQL();
            }
            if (!(this.query instanceof SelectUnion)) {
                throw DbException.get(42001, "recursive queries without UNION ALL");
            }
            SelectUnion selectUnion = (SelectUnion)this.query;
            if (selectUnion.getUnionType() != 1) {
                throw DbException.get(42001, "recursive queries without UNION ALL");
            }
            Query query = selectUnion.getLeft();
            query.disableCache();
            LocalResult localResult = query.query(0);
            LocalResult localResult2 = selectUnion.getEmptyResult();
            while (localResult.next()) {
                localResult2.addRow(localResult.currentRow());
            }
            Query query2 = selectUnion.getRight();
            localResult.reset();
            this.view.setRecursiveResult(localResult);
            query2.disableCache();
            while ((localResult = query2.query(0)).getRowCount() != 0) {
                while (localResult.next()) {
                    localResult2.addRow(localResult.currentRow());
                }
                localResult.reset();
                this.view.setRecursiveResult(localResult);
            }
            this.view.setRecursiveResult(null);
            localResult2.done();
            return new ViewCursor(this, localResult2, searchRow, searchRow2);
        }
        ArrayList<Parameter> arrayList = this.query.getParameters();
        if (this.originalParameters != null) {
            n2 = this.originalParameters.size();
            for (n = 0; n < n2; ++n) {
                Parameter parameter = this.originalParameters.get(n);
                int n3 = parameter.getIndex();
                Value value = parameter.getValue(session);
                ViewIndex.setParameter(arrayList, n3, value);
            }
        }
        n = searchRow != null ? searchRow.getColumnCount() : (searchRow2 != null ? searchRow2.getColumnCount() : 0);
        n2 = this.originalParameters == null ? 0 : this.originalParameters.size();
        n2 += this.view.getParameterOffset();
        for (int i = 0; i < n; ++i) {
            int n4;
            Value value;
            if (searchRow != null && (value = searchRow.getValue(i)) != null) {
                n4 = n2++;
                ViewIndex.setParameter(arrayList, n4, value);
            }
            if (searchRow2 == null || this.indexMasks[i] == 1 || (value = searchRow2.getValue(i)) == null) continue;
            n4 = n2++;
            ViewIndex.setParameter(arrayList, n4, value);
        }
        LocalResult localResult = this.query.query(0);
        return new ViewCursor(this, localResult, searchRow, searchRow2);
    }

    private static void setParameter(ArrayList<Parameter> arrayList, int n, Value value) {
        if (n >= arrayList.size()) {
            return;
        }
        Parameter parameter = arrayList.get(n);
        parameter.setValue(value);
    }

    private Query getQuery(Session session, int[] nArray) {
        int n;
        int n2;
        int n3;
        Query query = (Query)session.prepare(this.querySQL, true);
        if (nArray == null) {
            return query;
        }
        if (!query.allowGlobalConditions()) {
            return query;
        }
        int n4 = this.originalParameters == null ? 0 : this.originalParameters.size();
        n4 += this.view.getParameterOffset();
        IntArray intArray = new IntArray();
        int n5 = 0;
        for (n3 = 0; n3 < nArray.length; ++n3) {
            int n6 = nArray[n3];
            if (n6 == 0) continue;
            ++n5;
            intArray.add(n3);
            if (Integer.bitCount(n6) <= 1) continue;
            intArray.add(n3);
        }
        n3 = intArray.size();
        ArrayList<Column> arrayList = New.arrayList();
        int n7 = 0;
        while (n7 < n3) {
            Parameter parameter;
            n2 = intArray.get(n7);
            arrayList.add(this.table.getColumn(n2));
            n = nArray[n2];
            if ((n & 1) == 1) {
                parameter = new Parameter(n4 + n7);
                query.addGlobalCondition(parameter, n2, 16);
                ++n7;
            }
            if ((n & 2) == 2) {
                parameter = new Parameter(n4 + n7);
                query.addGlobalCondition(parameter, n2, 1);
                ++n7;
            }
            if ((n & 4) != 4) continue;
            parameter = new Parameter(n4 + n7);
            query.addGlobalCondition(parameter, n2, 3);
            ++n7;
        }
        this.columns = new Column[arrayList.size()];
        arrayList.toArray(this.columns);
        this.indexColumns = new IndexColumn[n5];
        this.columnIds = new int[n5];
        n2 = 0;
        for (n7 = 0; n7 < 2; ++n7) {
            for (n = 0; n < nArray.length; ++n) {
                int n8 = nArray[n];
                if (n8 == 0 || (n7 == 0 ? (n8 & 1) != 1 : (n8 & 1) == 1)) continue;
                IndexColumn indexColumn = new IndexColumn();
                indexColumn.column = this.table.getColumn(n);
                this.indexColumns[n2] = indexColumn;
                this.columnIds[n2] = indexColumn.column.getColumnId();
                ++n2;
            }
        }
        String string = query.getPlanSQL();
        query = (Query)session.prepare(string, true);
        return query;
    }

    @Override
    public void remove(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session) {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("VIEW");
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.getUnsupportedException("VIEW");
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    @Override
    public long getRowCount(Session session) {
        return 0L;
    }

    @Override
    public long getRowCountApproximation() {
        return 0L;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    static class CostElement {
        long evaluatedAt;
        double cost;

        CostElement() {
        }
    }
}

