/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import org.seasar.doma.internal.jdbc.sql.CallableSqlParameterVisitor;
import org.seasar.doma.internal.jdbc.sql.InParameter;
import org.seasar.doma.internal.jdbc.sql.OutParameter;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Reference;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class DomainInOutParameter<V, D>
implements InParameter,
OutParameter<V> {
    protected final DomainType<V, D> domainType;
    protected final Reference<D> reference;
    protected final DomainWrapper<V, D> wrapper;

    public DomainInOutParameter(DomainType<V, D> domainType, Reference<D> reference) {
        AssertionUtil.assertNotNull(domainType, reference);
        this.domainType = domainType;
        this.reference = reference;
        this.wrapper = domainType.getWrapper(reference.get());
    }

    @Override
    public Object getValue() {
        return this.reference.get();
    }

    @Override
    public Wrapper<V> getWrapper() {
        return this.domainType.getWrapper(this.reference.get());
    }

    @Override
    public void update() {
        this.reference.set(this.wrapper.getDomain());
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CallableSqlParameterVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitDomainInOutParameter(this, p);
    }
}

