/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.ExpressionValidator;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.decl.TypeDeclaration;
import org.seasar.doma.internal.apt.type.BasicType;
import org.seasar.doma.internal.apt.type.DomainType;
import org.seasar.doma.internal.apt.type.IterableType;
import org.seasar.doma.internal.apt.type.SimpleDataTypeVisitor;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.expr.ExpressionException;
import org.seasar.doma.internal.expr.ExpressionParser;
import org.seasar.doma.internal.expr.node.ExpressionNode;
import org.seasar.doma.internal.jdbc.sql.node.BindVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.BindVariableNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.ElseifNode;
import org.seasar.doma.internal.jdbc.sql.node.ElseifNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.EmbeddedVariableNode;
import org.seasar.doma.internal.jdbc.sql.node.EmbeddedVariableNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.ForNode;
import org.seasar.doma.internal.jdbc.sql.node.ForNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.IfNode;
import org.seasar.doma.internal.jdbc.sql.node.IfNodeVisitor;
import org.seasar.doma.internal.jdbc.sql.node.SqlLocation;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlValidator
implements BindVariableNodeVisitor<Void, Void>,
EmbeddedVariableNodeVisitor<Void, Void>,
IfNodeVisitor<Void, Void>,
ElseifNodeVisitor<Void, Void>,
ForNodeVisitor<Void, Void> {
    protected static final int SQL_MAX_LENGTH = 5000;
    protected final ProcessingEnvironment env;
    protected final ExecutableElement methodElement;
    protected final Map<String, TypeMirror> parameterTypeMap;
    protected final String path;
    protected final ExpressionValidator expressionValidator;

    public SqlValidator(ProcessingEnvironment env, ExecutableElement methodElement, Map<String, TypeMirror> parameterTypeMap, String path) {
        AssertionUtil.assertNotNull((Object)env, (Object)methodElement, parameterTypeMap, (Object)path);
        this.env = env;
        this.methodElement = methodElement;
        this.parameterTypeMap = parameterTypeMap;
        this.path = path;
        this.expressionValidator = new ExpressionValidator(env, methodElement, parameterTypeMap);
    }

    public void validate(SqlNode sqlNode) {
        try {
            sqlNode.accept(this, null);
            Set<String> validatedParameterNames = this.expressionValidator.getValidatedParameterNames();
            for (String parameterName : this.parameterTypeMap.keySet()) {
                if (validatedParameterNames.contains(parameterName)) continue;
                for (VariableElement variableElement : this.methodElement.getParameters()) {
                    if (!variableElement.getSimpleName().contentEquals(parameterName)) continue;
                    Notifier.notify(this.env, Diagnostic.Kind.ERROR, (MessageResource)Message.DOMA4122, variableElement, this.path, parameterName);
                }
            }
        }
        catch (AptIllegalStateException e) {
            throw e;
        }
        catch (AptException e) {
            Notifier.notify(this.env, e);
        }
    }

    @Override
    public Void visitBindVariableNode(BindVariableNode node, Void p) {
        SqlLocation location = node.getLocation();
        String variableName = node.getVariableName();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, variableName);
        if (node.getWordNode() != null) {
            if (!this.isBindable(typeDeclaration)) {
                String sql = this.getSql(location);
                throw new AptException((MessageResource)Message.DOMA4153, this.env, (Element)this.methodElement, this.path, sql, location.getLineNumber(), location.getPosition(), variableName, typeDeclaration.getBinaryName());
            }
        } else if (!this.isBindableIterable(typeDeclaration)) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4161, this.env, (Element)this.methodElement, this.path, sql, location.getLineNumber(), location.getPosition(), variableName, typeDeclaration.getBinaryName());
        }
        this.visitNode(node, p);
        return null;
    }

    protected boolean isBindable(TypeDeclaration typeDeclaration) {
        TypeMirror typeMirror = typeDeclaration.getType();
        return BasicType.newInstance(typeMirror, this.env) != null || DomainType.newInstance(typeMirror, this.env) != null;
    }

    protected boolean isBindableIterable(TypeDeclaration typeDeclaration) {
        TypeMirror typeMirror = typeDeclaration.getType();
        IterableType iterableType = IterableType.newInstance(typeMirror, this.env);
        if (iterableType != null) {
            return iterableType.getElementType().accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitBasicType(BasicType dataType, Void p) throws RuntimeException {
                    return true;
                }

                @Override
                public Boolean visitDomainType(DomainType dataType, Void p) throws RuntimeException {
                    return true;
                }
            }, null);
        }
        return false;
    }

    @Override
    public Void visitEmbeddedVariableNode(EmbeddedVariableNode node, Void p) {
        SqlLocation location = node.getLocation();
        String variableName = node.getVariableName();
        this.validateExpressionVariable(location, variableName);
        this.visitNode(node, p);
        return null;
    }

    @Override
    public Void visitIfNode(IfNode node, Void p) {
        String expression;
        SqlLocation location = node.getLocation();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, expression = node.getExpression());
        if (!typeDeclaration.isBooleanType()) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4140, this.env, (Element)this.methodElement, this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName());
        }
        this.visitNode(node, p);
        return null;
    }

    @Override
    public Void visitElseifNode(ElseifNode node, Void p) {
        String expression;
        SqlLocation location = node.getLocation();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, expression = node.getExpression());
        if (!typeDeclaration.isBooleanType()) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4141, this.env, (Element)this.methodElement, this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName());
        }
        this.visitNode(node, p);
        return null;
    }

    @Override
    public Void visitForNode(ForNode node, Void p) {
        SqlLocation location = node.getLocation();
        String identifier = node.getIdentifier();
        String expression = node.getExpression();
        TypeDeclaration typeDeclaration = this.validateExpressionVariable(location, expression);
        TypeMirror typeMirror = typeDeclaration.getType();
        if (!TypeMirrorUtil.isAssignable(typeMirror, Iterable.class, this.env)) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4149, this.env, (Element)this.methodElement, this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName());
        }
        DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(typeMirror, this.env);
        List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
        if (typeArgs.isEmpty()) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4150, this.env, (Element)this.methodElement, this.path, sql, location.getLineNumber(), location.getPosition(), expression, typeDeclaration.getBinaryName());
        }
        TypeMirror originalIdentifierType = this.expressionValidator.removeParameterType(identifier);
        this.expressionValidator.putParameterType(identifier, typeArgs.get(0));
        String hasNextVariable = identifier + "_has_next";
        TypeMirror originalHasNextType = this.expressionValidator.removeParameterType(hasNextVariable);
        this.expressionValidator.putParameterType(hasNextVariable, TypeMirrorUtil.getTypeMirror(Boolean.TYPE, this.env));
        String indexVariable = identifier + "_index";
        TypeMirror originalIndexType = this.expressionValidator.removeParameterType(indexVariable);
        this.expressionValidator.putParameterType(indexVariable, TypeMirrorUtil.getTypeMirror(Integer.TYPE, this.env));
        this.visitNode(node, p);
        if (originalIdentifierType == null) {
            this.expressionValidator.removeParameterType(identifier);
        } else {
            this.expressionValidator.putParameterType(identifier, originalIdentifierType);
        }
        if (originalHasNextType == null) {
            this.expressionValidator.removeParameterType(hasNextVariable);
        } else {
            this.expressionValidator.putParameterType(hasNextVariable, originalHasNextType);
        }
        if (originalIndexType == null) {
            this.expressionValidator.removeParameterType(indexVariable);
        } else {
            this.expressionValidator.putParameterType(indexVariable, originalIndexType);
        }
        return null;
    }

    @Override
    public Void visitUnknownNode(SqlNode node, Void p) {
        this.visitNode(node, p);
        return null;
    }

    protected Void visitNode(SqlNode node, Void p) {
        for (SqlNode child : node.getChildren()) {
            child.accept(this, p);
        }
        return null;
    }

    protected TypeDeclaration validateExpressionVariable(SqlLocation location, String expression) {
        ExpressionNode expressionNode = this.parseExpression(location, expression);
        try {
            return this.expressionValidator.validate(expressionNode);
        }
        catch (AptIllegalStateException e) {
            throw e;
        }
        catch (AptException e) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4092, this.env, (Element)this.methodElement, this.path, sql, location.getLineNumber(), location.getPosition(), e.getMessage());
        }
    }

    protected ExpressionNode parseExpression(SqlLocation location, String expression) {
        try {
            ExpressionParser parser = new ExpressionParser(expression);
            return parser.parse();
        }
        catch (ExpressionException e) {
            String sql = this.getSql(location);
            throw new AptException((MessageResource)Message.DOMA4092, this.env, (Element)this.methodElement, this.path, sql, location.getLineNumber(), location.getPosition(), e.getMessage());
        }
    }

    protected String getSql(SqlLocation location) {
        String sql = location.getSql();
        if (sql != null && sql.length() > 5000) {
            sql = sql.substring(0, 5000);
            sql = sql + Message.DOMA4185.getSimpleMessage(5000);
        }
        return sql;
    }
}

