/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql.node;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.sql.node.AbstractSqlNode;
import org.seasar.doma.internal.jdbc.sql.node.CommentNodeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcUnsupportedOperationException;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.SqlNodeVisitor;

public class CommentNode
extends AbstractSqlNode {
    protected final String comment;

    public CommentNode(String comment) {
        AssertionUtil.assertNotNull(comment);
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public void addNode(SqlNode child) {
        throw new JdbcUnsupportedOperationException(this.getClass().getName(), "addNode");
    }

    @Override
    public CommentNode copy() {
        return this;
    }

    @Override
    public <R, P> R accept(SqlNodeVisitor<R, P> visitor, P p) {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        if (visitor instanceof CommentNodeVisitor) {
            CommentNodeVisitor v = (CommentNodeVisitor)visitor;
            return v.visitCommentNode(this, p);
        }
        return visitor.visitUnknownNode(this, p);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.getClass().getSimpleName());
        buf.append(" ");
        buf.append(this.comment);
        buf.append("]");
        return buf.toString();
    }
}

