/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.ParameterBinder;
import org.seasar.doma.internal.jdbc.command.SetValueFunction;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlParameter;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.wrapper.Wrapper;

public class PreparedSqlParameterBinder
implements ParameterBinder<PreparedStatement, PreparedSqlParameter> {
    protected final Query query;

    public PreparedSqlParameterBinder(Query query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
    }

    @Override
    public void bind(PreparedStatement preparedStatement, List<? extends PreparedSqlParameter> paramters) throws SQLException {
        AssertionUtil.assertNotNull((Object)preparedStatement, paramters);
        int index = 1;
        JdbcMappingVisitor jdbcMappingVisitor = this.query.getConfig().getDialect().getJdbcMappingVisitor();
        for (PreparedSqlParameter preparedSqlParameter : paramters) {
            SetValueFunction function = new SetValueFunction(preparedStatement, index);
            Wrapper<?> wrapper = preparedSqlParameter.getWrapper();
            wrapper.accept(jdbcMappingVisitor, function);
            ++index;
        }
    }
}

