/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.builder;

import java.util.List;
import java.util.Map;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.Domain;
import org.seasar.doma.Entity;
import org.seasar.doma.EnumDomain;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.command.BasicIterationHandler;
import org.seasar.doma.internal.jdbc.command.BasicResultListHandler;
import org.seasar.doma.internal.jdbc.command.BasicSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.DomainIterationHandler;
import org.seasar.doma.internal.jdbc.command.DomainResultListHandler;
import org.seasar.doma.internal.jdbc.command.DomainSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.EntityIterationHandler;
import org.seasar.doma.internal.jdbc.command.EntityResultListHandler;
import org.seasar.doma.internal.jdbc.command.EntitySingleResultHandler;
import org.seasar.doma.internal.jdbc.command.MapIterationHandler;
import org.seasar.doma.internal.jdbc.command.MapResultListHandler;
import org.seasar.doma.internal.jdbc.command.MapSingleResultHandler;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.command.SelectCommand;
import org.seasar.doma.internal.jdbc.query.SqlSelectQuery;
import org.seasar.doma.internal.wrapper.WrapperException;
import org.seasar.doma.internal.wrapper.Wrappers;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.IterationCallback;
import org.seasar.doma.jdbc.SelectOptions;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.builder.BuildingHelper;
import org.seasar.doma.jdbc.builder.Param;
import org.seasar.doma.jdbc.builder.ParamIndex;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainTypeFactory;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.EntityTypeFactory;
import org.seasar.doma.message.Message;
import org.seasar.doma.wrapper.Wrapper;

public class SelectBuilder {
    private final Config config;
    private final BuildingHelper helper;
    private final SqlSelectQuery query;
    private final ParamIndex paramIndex;

    private SelectBuilder(Config config) {
        this.config = config;
        this.helper = new BuildingHelper();
        this.query = new SqlSelectQuery();
        this.query.setConfig(config);
        this.query.setCallerClassName(this.getClass().getName());
        this.paramIndex = new ParamIndex();
    }

    private SelectBuilder(Config config, BuildingHelper builder, SqlSelectQuery query, ParamIndex parameterIndex) {
        this.config = config;
        this.helper = builder;
        this.query = query;
        this.paramIndex = parameterIndex;
    }

    public static SelectBuilder newInstance(Config config) {
        if (config == null) {
            throw new DomaNullPointerException("config");
        }
        return new SelectBuilder(config);
    }

    public SelectBuilder sql(String sql) {
        if (sql == null) {
            throw new DomaNullPointerException("sql");
        }
        this.helper.appendSqlWithLineSeparator(sql);
        return new SubsequentSelectBuilder(this.config, this.helper, this.query, this.paramIndex);
    }

    public SelectBuilder removeLast() {
        this.helper.removeLast();
        return new SubsequentSelectBuilder(this.config, this.helper, this.query, this.paramIndex);
    }

    public <P> SelectBuilder param(Class<P> paramClass, P param) {
        if (paramClass == null) {
            throw new DomaNullPointerException("paramClass");
        }
        this.helper.appendParam(new Param(paramClass, param, this.paramIndex));
        this.paramIndex.increment();
        return new SubsequentSelectBuilder(this.config, this.helper, this.query, this.paramIndex);
    }

    public <R> R getSingleResult(Class<R> resultClass) {
        if (resultClass == null) {
            throw new DomaNullPointerException("resultClass");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getSingleResult");
        }
        ResultSetHandler<R> singleResultHandler = this.createSingleResultHanlder(resultClass);
        return this.execute(singleResultHandler);
    }

    public Map<String, Object> getSingleResult(MapKeyNamingType mapKeyNamingType) {
        if (mapKeyNamingType == null) {
            throw new DomaNullPointerException("mapKeyNamingType");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getSingleResult");
        }
        MapSingleResultHandler singleResultHandler = new MapSingleResultHandler(mapKeyNamingType);
        return this.execute(singleResultHandler);
    }

    private <R> ResultSetHandler<R> createSingleResultHanlder(Class<R> resultClass) {
        if (resultClass.isAnnotationPresent(Entity.class)) {
            EntityType<R> entityType = EntityTypeFactory.getEntityType(resultClass, this.config.getClassHelper());
            return new EntitySingleResultHandler<R>(entityType);
        }
        if (resultClass.isAnnotationPresent(Domain.class) || resultClass.isAnnotationPresent(EnumDomain.class)) {
            DomainType domainType = DomainTypeFactory.getDomainType(resultClass, this.config.getClassHelper());
            return new DomainSingleResultHandler<R>(domainType);
        }
        DomainType domainType = DomainTypeFactory.getExternalDomainType(resultClass, this.config.getClassHelper());
        if (domainType != null) {
            return new DomainSingleResultHandler<R>(domainType);
        }
        try {
            Wrapper<?> wrapper = Wrappers.wrap(null, resultClass, this.config.getClassHelper());
            return new BasicSingleResultHandler(wrapper, resultClass.isPrimitive());
        }
        catch (WrapperException e) {
            throw new DomaIllegalArgumentException("resultClass", Message.DOMA2204.getMessage(resultClass, e));
        }
    }

    public <R> List<R> getResultList(Class<R> resultClass) {
        if (resultClass == null) {
            throw new DomaNullPointerException("resultClass");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getResultList");
        }
        ResultSetHandler<List<R>> resultListHandler = this.createResultListHanlder(resultClass);
        return this.execute(resultListHandler);
    }

    public List<Map<String, Object>> getResultList(MapKeyNamingType mapKeyNamingType) {
        if (mapKeyNamingType == null) {
            throw new DomaNullPointerException("mapKeyNamingType");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getResultList");
        }
        MapResultListHandler resultListHandler = new MapResultListHandler(mapKeyNamingType);
        return this.execute(resultListHandler);
    }

    private <R> ResultSetHandler<List<R>> createResultListHanlder(Class<R> resultClass) {
        if (resultClass.isAnnotationPresent(Entity.class)) {
            EntityType<R> entityType = EntityTypeFactory.getEntityType(resultClass, this.config.getClassHelper());
            return new EntityResultListHandler<R>(entityType);
        }
        if (resultClass.isAnnotationPresent(Domain.class) || resultClass.isAnnotationPresent(EnumDomain.class)) {
            DomainType domainType = DomainTypeFactory.getDomainType(resultClass, this.config.getClassHelper());
            return new DomainResultListHandler<R>(domainType);
        }
        DomainType domainType = DomainTypeFactory.getExternalDomainType(resultClass, this.config.getClassHelper());
        if (domainType != null) {
            return new DomainResultListHandler<R>(domainType);
        }
        try {
            Wrapper<?> wrapper = Wrappers.wrap(null, resultClass, this.config.getClassHelper());
            return new BasicResultListHandler(wrapper);
        }
        catch (WrapperException e) {
            throw new DomaIllegalArgumentException("resultClass", Message.DOMA2204.getMessage(resultClass, e));
        }
    }

    public <R, T> R iterate(Class<T> targetClass, IterationCallback<R, T> iterationCallback) {
        if (targetClass == null) {
            throw new DomaNullPointerException("targetClass");
        }
        if (iterationCallback == null) {
            throw new DomaNullPointerException("iterationCallback");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("iterate");
        }
        ResultSetHandler<R> iterationHandler = this.createIterationHanlder(targetClass, iterationCallback);
        return this.execute(iterationHandler);
    }

    public <R> R iterate(MapKeyNamingType mapKeyNamingType, IterationCallback<R, Map<String, Object>> iterationCallback) {
        if (mapKeyNamingType == null) {
            throw new DomaNullPointerException("mapKeyNamingType");
        }
        if (iterationCallback == null) {
            throw new DomaNullPointerException("iterationCallback");
        }
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("iterate");
        }
        MapIterationHandler<R> iterationHandler = new MapIterationHandler<R>(mapKeyNamingType, iterationCallback);
        return this.execute(iterationHandler);
    }

    private <R, T> ResultSetHandler<R> createIterationHanlder(Class<T> targetClass, IterationCallback<R, T> iterationCallback) {
        if (targetClass.isAnnotationPresent(Entity.class)) {
            EntityType<T> entityType = EntityTypeFactory.getEntityType(targetClass, this.config.getClassHelper());
            return new EntityIterationHandler<R, T>(entityType, iterationCallback);
        }
        if (targetClass.isAnnotationPresent(Domain.class) || targetClass.isAnnotationPresent(EnumDomain.class)) {
            DomainType domainType = DomainTypeFactory.getDomainType(targetClass, this.config.getClassHelper());
            return new DomainIterationHandler<R, T>(domainType, iterationCallback);
        }
        DomainType domainType = DomainTypeFactory.getExternalDomainType(targetClass, this.config.getClassHelper());
        if (domainType != null) {
            return new DomainIterationHandler<R, T>(domainType, iterationCallback);
        }
        try {
            Wrapper<?> wrapper = Wrappers.wrap(null, targetClass, this.config.getClassHelper());
            return new BasicIterationHandler(wrapper, iterationCallback);
        }
        catch (WrapperException e) {
            throw new DomaIllegalArgumentException("resultClass", Message.DOMA2204.getMessage(targetClass, e));
        }
    }

    private <R> R execute(ResultSetHandler<R> resultSetHandler) {
        for (Param p : this.helper.getParams()) {
            this.query.addParameter(p.name, p.paramClass, p.param);
        }
        this.query.setSqlNode(this.helper.getSqlNode());
        this.query.prepare();
        SelectCommand<R> command = new SelectCommand<R>(this.query, resultSetHandler);
        R result = command.execute();
        this.query.complete();
        return result;
    }

    public void ensureResult(boolean ensureResult) {
        this.query.setResultEnsured(ensureResult);
    }

    public void ensureResultMapping(boolean ensureResultMapping) {
        this.query.setResultMappingEnsured(ensureResultMapping);
    }

    public void fetchSize(int fetchSize) {
        this.query.setFetchSize(fetchSize);
    }

    public void maxRows(int maxRows) {
        this.query.setMaxRows(maxRows);
    }

    public void queryTimeout(int queryTimeout) {
        this.query.setQueryTimeout(queryTimeout);
    }

    public void callerClassName(String className) {
        if (className == null) {
            throw new DomaNullPointerException("className");
        }
        this.query.setCallerClassName(className);
    }

    public void callerMethodName(String methodName) {
        if (methodName == null) {
            throw new DomaNullPointerException("methodName");
        }
        this.query.setCallerMethodName(methodName);
    }

    public void options(SelectOptions options) {
        if (options == null) {
            throw new DomaNullPointerException("options");
        }
        this.query.setOptions(options);
    }

    public Sql<?> getSql() {
        if (this.query.getMethodName() == null) {
            this.query.setCallerMethodName("getSql");
        }
        this.query.setSqlNode(this.helper.getSqlNode());
        this.query.prepare();
        return this.query.getSql();
    }

    private static class SubsequentSelectBuilder
    extends SelectBuilder {
        private SubsequentSelectBuilder(Config config, BuildingHelper builder, SqlSelectQuery query, ParamIndex paramIndex) {
            super(config, builder, query, paramIndex);
        }

        @Override
        public SelectBuilder sql(String fragment) {
            ((SelectBuilder)this).helper.appendSql(fragment);
            return this;
        }
    }
}

