/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.jdbc.command.MapFetcher;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.IterationCallback;
import org.seasar.doma.jdbc.IterationContext;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.PostIterationCallback;

public class MapIterationHandler<R>
implements ResultSetHandler<R> {
    private final MapKeyNamingType mapKeyNamingType;
    protected final IterationCallback<R, Map<String, Object>> iterationCallback;

    public MapIterationHandler(MapKeyNamingType mapKeyNamingType, IterationCallback<R, Map<String, Object>> iterationCallback) {
        AssertionUtil.assertNotNull((Object)mapKeyNamingType, iterationCallback);
        this.mapKeyNamingType = mapKeyNamingType;
        this.iterationCallback = iterationCallback;
    }

    @Override
    public R handle(ResultSet resultSet, SelectQuery query) throws SQLException {
        AssertionUtil.assertNotNull((Object)resultSet, (Object)query);
        MapFetcher fetcher = new MapFetcher(query, this.mapKeyNamingType);
        IterationContext iterationContext = new IterationContext();
        boolean existent = false;
        R result = null;
        while (resultSet.next()) {
            existent = true;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            fetcher.fetch(resultSet, (Map<String, Object>)map);
            result = this.iterationCallback.iterate(map, iterationContext);
            if (!iterationContext.isExited()) continue;
            return result;
        }
        if (query.isResultEnsured() && !existent) {
            PreparedSql sql = query.getSql();
            throw new NoResultException(query.getConfig().getExceptionSqlLogType(), sql);
        }
        if (this.iterationCallback instanceof PostIterationCallback) {
            result = ((PostIterationCallback)this.iterationCallback).postIterate(result, iterationContext);
        }
        return result;
    }
}

