/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.Connection;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.command.Command;
import org.seasar.doma.internal.jdbc.query.CreateQuery;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class CreateCommand<R>
implements Command<R, CreateQuery<R>> {
    protected final CreateQuery<R> query;

    public CreateCommand(CreateQuery<R> query) {
        this.query = query;
    }

    @Override
    public R execute() {
        Connection connection = JdbcUtil.getConnection(this.query.getConfig().getDataSource());
        try {
            R r = this.query.create(connection);
            return r;
        }
        catch (SQLException e) {
            throw new JdbcException((MessageResource)Message.DOMA2008, (Throwable)e, e);
        }
        finally {
            JdbcUtil.close(connection, this.query.getConfig().getJdbcLogger());
        }
    }
}

