/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.unit;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.action.Forward;
import org.seasar.cubby.action.Redirect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubbyAssert {
    private static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";

    public static void assertPathEquals(Class<? extends ActionResult> expectedType, String expectedPath, ActionResult actual) {
        CubbyAssert.assertPathEquals(expectedType, expectedPath, actual, DEFAULT_CHARACTER_ENCODING);
    }

    public static void assertPathEquals(String message, Class<? extends ActionResult> expectedType, String expectedPath, ActionResult actual) {
        CubbyAssert.assertPathEquals(message, expectedType, expectedPath, actual, DEFAULT_CHARACTER_ENCODING);
    }

    public static void assertPathEquals(Class<? extends ActionResult> expectedType, String expectedPath, ActionResult actual, String characterEncoding) {
        CubbyAssert.assertPathEquals(null, expectedType, expectedPath, actual, characterEncoding);
    }

    public static void assertPathEquals(String message, Class<? extends ActionResult> expectedType, String expectedPath, ActionResult actual, String characterEncoding) {
        ArrayList asserters = new ArrayList();
        asserters.add(new ForwardAssert());
        asserters.add(new RedirectAssert());
        CubbyAssert.assertActionResult(message, expectedType, actual, asserters, expectedPath, characterEncoding);
    }

    protected static <E> void assertActionResult(String message, Class<? extends ActionResult> expectedType, ActionResult actualResult, List<ActionResultAssert<?, E>> asserters, E expected, Object ... args) {
        Assert.assertNotNull((String)message, (Object)actualResult);
        Assert.assertEquals((String)message, expectedType, actualResult.getClass());
        for (ActionResultAssert<?, E> asserter : asserters) {
            asserter.assertType(message, actualResult, expected, args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RedirectAssert
    extends PathAssert<Redirect> {
        protected RedirectAssert() {
            super(Redirect.class);
        }

        @Override
        void doAssert(String message, Redirect actualResult, String expected, Object ... args) {
            this.doPathAssert(message, expected, actualResult.getPath(args[0].toString()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ForwardAssert
    extends PathAssert<Forward> {
        protected ForwardAssert() {
            super(Forward.class);
        }

        @Override
        void doAssert(String message, Forward actualResult, String expected, Object ... args) {
            this.doPathAssert(message, expected, actualResult.getPath(args[0].toString()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class PathAssert<T extends ActionResult>
    extends ActionResultAssert<T, String> {
        PathAssert(Class<T> clazz) {
            super(clazz);
        }

        protected void doPathAssert(String message, String expectedPath, String actualPath) {
            Assert.assertEquals((String)message, (String)expectedPath, (String)actualPath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class ActionResultAssert<T extends ActionResult, E> {
        private final Class<T> clazz;

        ActionResultAssert(Class<T> clazz) {
            this.clazz = clazz;
        }

        public void assertType(String message, ActionResult actualResult, E expected, Object ... args) {
            if (this.clazz.isInstance(actualResult)) {
                this.doAssert(message, (ActionResult)this.clazz.cast(actualResult), expected, args);
            }
        }

        abstract void doAssert(String var1, T var2, E var3, Object ... var4);
    }
}

