/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.spring.spi;

import org.seasar.cubby.routing.PathResolver;
import org.seasar.cubby.spi.PathResolverProvider;
import org.seasar.cubby.util.ActionUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringPathResolverProvider
implements PathResolverProvider,
ApplicationContextAware {
    @Autowired
    private PathResolver pathResolver;
    private ApplicationContext applicationContext;
    private boolean initialized = false;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void initialize() {
        String[] names;
        if (this.initialized) {
            return;
        }
        for (String beanDefinitionName : names = BeanFactoryUtils.beanNamesIncludingAncestors((ListableBeanFactory)this.applicationContext)) {
            Class type = this.applicationContext.getType(beanDefinitionName);
            if (!ActionUtils.isActionClass((Class)type)) continue;
            this.pathResolver.add(type);
        }
        this.initialized = true;
    }

    public PathResolver getPathResolver() {
        return this.pathResolver;
    }
}

