/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.extension.jdbc.util.BindVariableUtil;
import org.seasar.framework.util.FloatConversionUtil;

public class FloatType
extends AbstractValueType {
    public FloatType() {
        super(6);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return FloatConversionUtil.toFloat((Object)resultSet.getObject(index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return FloatConversionUtil.toFloat((Object)resultSet.getObject(columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return FloatConversionUtil.toFloat((Object)cs.getObject(index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return FloatConversionUtil.toFloat((Object)cs.getObject(parameterName));
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setFloat(index, FloatConversionUtil.toPrimitiveFloat((Object)value));
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setFloat(parameterName, FloatConversionUtil.toPrimitiveFloat((Object)value));
        }
    }

    public String toText(Object value) {
        if (value == null) {
            return BindVariableUtil.nullText();
        }
        Float var = FloatConversionUtil.toFloat((Object)value);
        return BindVariableUtil.toText(var);
    }
}

