/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.oval;

import javax.servlet.ServletContext;
import net.sf.oval.Validator;
import net.sf.oval.localization.context.OValContextRenderer;
import net.sf.oval.localization.message.MessageResolver;
import net.sf.oval.logging.LoggerFactory;
import net.sf.oval.logging.LoggerFactorySLF4JImpl;
import org.seasar.cubby.plugin.AbstractPlugin;
import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.ProviderFactory;
import org.seasar.cubby.spi.container.Container;
import org.seasar.cubby.spi.container.LookupException;

public class OValPlugin
extends AbstractPlugin {
    public void initialize(ServletContext servletContext) throws Exception {
        Validator.setLoggerFactory((LoggerFactory)new LoggerFactorySLF4JImpl());
    }

    public void ready() {
        OValContextRenderer ovalContextRenderer;
        Container container = ((ContainerProvider)ProviderFactory.get(ContainerProvider.class)).getContainer();
        MessageResolver messageResolver = this.buildMessageResolver(container);
        if (messageResolver != null) {
            Validator.setMessageResolver((MessageResolver)messageResolver);
        }
        if ((ovalContextRenderer = this.buildOValContextRenderer(container)) != null) {
            Validator.setContextRenderer((OValContextRenderer)ovalContextRenderer);
        }
    }

    protected MessageResolver buildMessageResolver(Container container) {
        try {
            return (MessageResolver)container.lookup(MessageResolver.class);
        }
        catch (LookupException e) {
            return null;
        }
    }

    protected OValContextRenderer buildOValContextRenderer(Container container) {
        try {
            return (OValContextRenderer)container.lookup(OValContextRenderer.class);
        }
        catch (LookupException e) {
            return null;
        }
    }
}

