/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.query;

import org.seasar.extension.jdbc.AutoFunctionCall;
import org.seasar.extension.jdbc.manager.JdbcManagerImplementor;
import org.seasar.extension.jdbc.query.AbstractFunctionCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoFunctionCallImpl<T>
extends AbstractFunctionCall<T, AutoFunctionCall<T>>
implements AutoFunctionCall<T> {
    protected String functionName;

    public AutoFunctionCallImpl(JdbcManagerImplementor jdbcManager, Class<T> resultClass, String functionName) {
        this(jdbcManager, resultClass, functionName, null);
    }

    public AutoFunctionCallImpl(JdbcManagerImplementor jdbcManager, Class<T> resultClass, String functionName, Object param) {
        super(jdbcManager, resultClass);
        if (functionName == null) {
            throw new NullPointerException("functionName");
        }
        this.functionName = functionName;
        this.parameter = param;
    }

    @Override
    protected void prepare(String methodName) {
        this.prepareCallerClassAndMethodName(methodName);
        this.prepareReturnParameter();
        this.prepareParameter();
        this.prepareSql();
    }

    protected void prepareSql() {
        StringBuilder buf = new StringBuilder(100).append("{? = call ").append(this.functionName);
        int paramSize = this.getParamSize();
        buf.append("(");
        if (paramSize > 1) {
            for (int i = 1; i < paramSize; ++i) {
                buf.append("?, ");
            }
            buf.setLength(buf.length() - 2);
        }
        buf.append(")");
        this.executedSql = new String(buf.append("}"));
    }
}

