/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.servlet.FilterPipeline;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.ManagedFilterPipeline;
import com.google.inject.servlet.ManagedServletPipeline;
import com.google.inject.servlet.RequestParameters;
import com.google.inject.servlet.RequestScoped;
import com.google.inject.servlet.ServletScopes;
import com.google.inject.servlet.SessionScoped;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

final class InternalServletModule
extends AbstractModule {
    InternalServletModule() {
    }

    protected void configure() {
        this.bindScope(RequestScoped.class, ServletScopes.REQUEST);
        this.bindScope(SessionScoped.class, ServletScopes.SESSION);
        Provider<HttpServletRequest> requestProvider = new Provider<HttpServletRequest>(){

            public HttpServletRequest get() {
                return GuiceFilter.getRequest();
            }

            public String toString() {
                return "RequestProvider";
            }
        };
        this.bind(HttpServletRequest.class).toProvider((Provider)requestProvider);
        this.bind(ServletRequest.class).toProvider((Provider)requestProvider);
        Provider<HttpServletResponse> responseProvider = new Provider<HttpServletResponse>(){

            public HttpServletResponse get() {
                return GuiceFilter.getResponse();
            }

            public String toString() {
                return "ResponseProvider";
            }
        };
        this.bind(HttpServletResponse.class).toProvider((Provider)responseProvider);
        this.bind(ServletResponse.class).toProvider((Provider)responseProvider);
        this.bind(HttpSession.class).toProvider((Provider)new Provider<HttpSession>(){

            public HttpSession get() {
                return GuiceFilter.getRequest().getSession();
            }

            public String toString() {
                return "SessionProvider";
            }
        });
        this.bind(ServletContext.class).toProvider((Provider)new Provider<ServletContext>(){

            public ServletContext get() {
                return GuiceFilter.getServletContext();
            }

            public String toString() {
                return "ServletContextProvider";
            }
        });
        this.bind((TypeLiteral)new TypeLiteral<Map<String, String[]>>(){}).annotatedWith(RequestParameters.class).toProvider((Provider)new Provider<Map<String, String[]>>(){

            public Map<String, String[]> get() {
                return GuiceFilter.getRequest().getParameterMap();
            }

            public String toString() {
                return "RequestParametersProvider";
            }
        });
        this.requestStaticInjection(new Class[]{GuiceFilter.class});
        this.bind(ManagedServletPipeline.class);
        this.bind(FilterPipeline.class).to(ManagedFilterPipeline.class).asEagerSingleton();
    }

    public boolean equals(Object o) {
        return o instanceof InternalServletModule;
    }

    public int hashCode() {
        return InternalServletModule.class.hashCode();
    }
}

