/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.seasar.extension.dataset.DataSet;
import org.seasar.extension.dataset.DataTable;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.jpa.unit.EntityReader;
import org.seasar.framework.jpa.unit.EntityReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S2Assert
extends Assert {
    protected static final S2TestCaseAdapter adapter = new S2TestCaseAdapter();

    protected S2Assert() {
    }

    public static void assertEquals(DataSet expected, DataSet actual) {
        adapter.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, DataSet expected, DataSet actual) {
        adapter.assertEquals(message, expected, actual);
    }

    public static void assertEquals(DataTable expected, DataTable actual) {
        adapter.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, DataTable expected, DataTable actual) {
        adapter.assertEquals(message, expected, actual);
    }

    public static void assertEquals(DataSet expected, Object actual) {
        adapter.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String message, DataSet expected, Object actual) {
        adapter.assertEquals(message, expected, actual);
    }

    public static <V> void assertMapEquals(DataSet expected, Map<String, V> map) {
        adapter.assertMapEquals(null, expected, map);
    }

    public static <V> void assertMapEquals(String message, DataSet expected, Map<String, V> map) {
        adapter.assertMapEquals(message, expected, map);
    }

    public static <V> void assertMapEquals(DataSet expected, List<Map<String, V>> list) {
        adapter.assertMapListEquals(null, expected, list);
    }

    public static <V> void assertMapEquals(String message, DataSet expected, List<Map<String, V>> list) {
        adapter.assertMapListEquals(message, expected, list);
    }

    public static void assertBeanEquals(DataSet expected, Object bean) {
        adapter.assertBeanEquals(null, expected, bean);
    }

    public static void assertBeanEquals(String message, DataSet expected, Object bean) {
        adapter.assertBeanEquals(message, expected, bean);
    }

    public static void assertBeanEquals(DataSet expected, List<?> list) {
        adapter.assertBeanListEquals(null, expected, list);
    }

    public static void assertBeanEquals(String message, DataSet expected, List<?> list) {
        adapter.assertBeanListEquals(message, expected, list);
    }

    public static void assertEntityEquals(DataSet expected, Object entity) {
        S2Assert.assertEntityEquals(null, expected, entity);
    }

    public static void assertEntityEquals(String message, DataSet expected, Object entity) {
        EntityReader reader = EntityReaderFactory.getEntityReader(entity);
        S2Assert.assertEqualsIgnoreTableOrder(message, expected, reader.read());
    }

    public static void assertEntityEquals(DataSet expected, Collection<?> entities) {
        S2Assert.assertEntityEquals(null, expected, entities);
    }

    public static void assertEntityEquals(String message, DataSet expected, Collection<?> entities) {
        EntityReader reader = EntityReaderFactory.getEntityReader(entities);
        S2Assert.assertEqualsIgnoreTableOrder(message, expected, reader.read());
    }

    public static void assertEqualsIgnoreTableOrder(DataSet expected, DataSet actual) {
        S2Assert.assertEqualsIgnoreTableOrder(null, expected, actual);
    }

    public static void assertEqualsIgnoreTableOrder(String message, DataSet expected, DataSet actual) {
        message = message == null ? "" : message;
        for (int i = 0; i < expected.getTableSize(); ++i) {
            String tableName = expected.getTable(i).getTableName();
            String notFound = message + ":Table " + tableName + " was not found.";
            S2Assert.assertTrue((String)notFound, (boolean)actual.hasTable(tableName));
            S2Assert.assertEquals(message, expected.getTable(i), actual.getTable(tableName));
        }
    }

    protected static class S2TestCaseAdapter
    extends S2TestCase {
        protected S2TestCaseAdapter() {
        }

        protected void assertMapEquals(String message, DataSet expected, Map map) {
            super.assertMapEquals(message, expected, map);
        }

        protected void assertMapListEquals(String message, DataSet expected, List list) {
            super.assertMapListEquals(message, expected, list);
        }

        protected void assertBeanEquals(String message, DataSet expected, Object bean) {
            super.assertBeanEquals(message, expected, bean);
        }

        protected void assertBeanListEquals(String message, DataSet expected, List list) {
            super.assertBeanListEquals(message, expected, list);
        }
    }
}

