/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dbcp.impl;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.seasar.extension.dbcp.DBXAResource;
import org.seasar.extension.jta.xa.DefaultXAResource;
import org.seasar.framework.exception.SXAException;

public class DBXAResourceImpl
extends DefaultXAResource
implements DBXAResource {
    private Connection connection;

    public DBXAResourceImpl(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    protected void doBegin(Xid xid) throws XAException {
        try {
            if (this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(false);
            }
        }
        catch (SQLException ex) {
            throw new SXAException((Throwable)ex);
        }
    }

    protected void doCommit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException ex) {
            throw new SXAException((Throwable)ex);
        }
    }

    protected int doPrepare(Xid xid) throws XAException {
        try {
            if (this.connection.isClosed()) {
                return 3;
            }
            return 0;
        }
        catch (SQLException ex) {
            throw new SXAException((Throwable)ex);
        }
    }

    protected void doRollback(Xid xid) throws XAException {
        try {
            this.connection.rollback();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException ex) {
            throw new SXAException((Throwable)ex);
        }
    }
}

