/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;

public class EmailValidator
implements ScalarFieldValidator {
    private static final String SPECIAL_CHARS = "\\(\\)<>@,;:\\\\\\\"\\.\\[\\]";
    private static final String VALID_CHARS = "[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]";
    private static final String QUOTED_USER = "(\"[^\"]*\")";
    private static final String ATOM = "[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+";
    private static final String WORD = "([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+|(\"[^\"]*\"))";
    private static final String LEGAL_ASCII_PATTERN = "^[\\x00-\\x7F]+$";
    private static final String EMAIL_PATTERN = "^(.+)@(.+)$";
    private static final String IP_DOMAIN_PATTERN = "^(\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})[.](\\d{1,3})$";
    private static final String USER_PATTERN = "^([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+|(\"[^\"]*\"))(\\.([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+|(\"[^\"]*\")))*$";
    private static final String DOMAIN_PATTERN = "^[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+(\\.[^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+)*$";
    private static final String ATOM_PATTERN = "([^\\s\\(\\)<>@,;:\\\\\\\"\\.\\[\\]]+)";
    private final String messageKey;

    public EmailValidator() {
        this("valid.email");
    }

    public EmailValidator(String messageKey) {
        this.messageKey = messageKey;
    }

    public void validate(ValidationContext context, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            Matcher matcher;
            Pattern pattern;
            boolean match;
            String email = (String)value;
            if (StringUtils.isEmpty(email)) {
                return;
            }
            boolean bl = match = !email.endsWith(".");
            if (match) {
                pattern = Pattern.compile(LEGAL_ASCII_PATTERN);
                Matcher matchAsciiPat = pattern.matcher(email);
                match = matchAsciiPat.matches();
            }
            if (match && (match = (matcher = (pattern = Pattern.compile(EMAIL_PATTERN)).matcher(email)).find()) && this.isValidUser(matcher.group(1)) && this.isValidDomain(matcher.group(2))) {
                return;
            }
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setKey(this.messageKey);
        context.addMessageInfo(messageInfo);
    }

    private boolean isValidDomain(String domain) {
        Matcher domainMatcher;
        Pattern pattern = Pattern.compile(IP_DOMAIN_PATTERN);
        Matcher ipAddressMatcher = pattern.matcher(domain);
        return ipAddressMatcher.find() ? this.isValidIpAddress(ipAddressMatcher) : (domainMatcher = (pattern = Pattern.compile(DOMAIN_PATTERN)).matcher(domain)).matches() && this.isValidSymbolicDomain(domain);
    }

    private boolean isValidUser(String user) {
        Pattern pattern = Pattern.compile(USER_PATTERN);
        Matcher userMatcher = pattern.matcher(user);
        return userMatcher.matches();
    }

    private boolean isValidIpAddress(Matcher ipAddressMatcher) {
        for (int i = 1; i <= 4; ++i) {
            String ipSegment = ipAddressMatcher.group(i);
            if (ipSegment == null || ipSegment.length() <= 0) {
                return false;
            }
            int iIpSegment = 0;
            try {
                iIpSegment = Integer.parseInt(ipSegment);
            }
            catch (NumberFormatException e) {
                return false;
            }
            if (iIpSegment <= 255) continue;
            return false;
        }
        return true;
    }

    private boolean isValidSymbolicDomain(String domain) {
        String end;
        ArrayList<String> domainSegments = new ArrayList<String>();
        boolean match = true;
        Pattern pattern = Pattern.compile(ATOM_PATTERN);
        String currentDomain = domain;
        while (match) {
            Matcher atomMatcher = pattern.matcher(currentDomain);
            match = atomMatcher.find();
            if (!match) continue;
            String domainSegment = atomMatcher.group(1);
            domainSegments.add(domainSegment);
            int domainSegmentLength = domainSegment.length() + 1;
            currentDomain = domainSegmentLength >= currentDomain.length() ? "" : currentDomain.substring(domainSegmentLength);
        }
        int size = domainSegments.size();
        if (size > 0 && ((end = (String)domainSegments.get(size - 1)).length() < 2 || end.length() > 4)) {
            return false;
        }
        return size >= 2;
    }
}

