/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import org.easymock.ArgumentsMatcher;
import org.easymock.internal.matchers.ArrayEquals;

public class Invocation {
    private final Object mock;
    private final Method method;
    private final Object[] arguments;

    public Invocation(Object mock, Method method, Object[] args) {
        this.mock = mock;
        this.method = method;
        this.arguments = Invocation.expandVarArgs(method.isVarArgs(), args);
    }

    private static Object[] expandVarArgs(boolean isVarArgs, Object[] args) {
        if (!isVarArgs || isVarArgs && args[args.length - 1] != null && !args[args.length - 1].getClass().isArray()) {
            return args == null ? new Object[]{} : args;
        }
        Object[] varArgs = ArrayEquals.createObjectArray(args[args.length - 1]);
        int nonVarArgsCount = args.length - 1;
        int varArgsCount = varArgs.length;
        Object[] newArgs = new Object[nonVarArgsCount + varArgsCount];
        System.arraycopy(args, 0, newArgs, 0, nonVarArgsCount);
        System.arraycopy(varArgs, 0, newArgs, nonVarArgsCount, varArgsCount);
        return newArgs;
    }

    public Object getMock() {
        return this.mock;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Invocation other = (Invocation)o;
        return this.mock.equals(other.mock) && this.method.equals(other.method) && this.equalArguments(other.arguments);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("hashCode() is not implemented");
    }

    private boolean equalArguments(Object[] arguments) {
        if (this.arguments.length != arguments.length) {
            return false;
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            Object myArgument = this.arguments[i];
            Object otherArgument = arguments[i];
            if (!(this.isPrimitiveParameter(i) ? !myArgument.equals(otherArgument) : myArgument != otherArgument)) continue;
            return false;
        }
        return true;
    }

    private boolean isPrimitiveParameter(int parameterPosition) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        if (this.method.isVarArgs()) {
            parameterPosition = Math.min(parameterPosition, parameterTypes.length - 1);
        }
        return parameterTypes[parameterPosition].isPrimitive();
    }

    public boolean matches(Invocation actual, ArgumentsMatcher matcher) {
        return this.mock.equals(actual.mock) && this.method.equals(actual.method) && matcher.matches(this.arguments, actual.arguments);
    }

    public String toString(ArgumentsMatcher matcher) {
        return this.method.getName() + "(" + matcher.toString(this.arguments) + ")";
    }
}

