/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.s2.spi;

import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.container.Container;
import org.seasar.cubby.spi.container.LookupException;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.CyclicReferenceRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.TooManyRegistrationRuntimeException;

public class S2ContainerProvider
implements ContainerProvider {
    public static final String s2Container_BINDING = "bindingType=must";
    private final Container container = new S2ContainerImpl();
    private S2Container s2Container;

    public void setS2Container(S2Container s2Container) {
        this.s2Container = s2Container;
    }

    public Container getContainer() {
        return this.container;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class S2ContainerImpl
    implements Container {
        private S2ContainerImpl() {
        }

        public <T> T lookup(Class<T> type) throws LookupException {
            try {
                T component = type.cast(S2ContainerProvider.this.s2Container.getRoot().getComponent(type));
                if (component == null) {
                    throw new LookupException();
                }
                return component;
            }
            catch (ComponentNotFoundRuntimeException e) {
                throw new LookupException((Throwable)e);
            }
            catch (TooManyRegistrationRuntimeException e) {
                throw new LookupException((Throwable)e);
            }
            catch (CyclicReferenceRuntimeException e) {
                throw new LookupException((Throwable)e);
            }
        }
    }
}

