/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.util;

import java.lang.reflect.Method;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.seasar.cubby.action.Action;
import org.seasar.cubby.action.ActionClass;
import org.seasar.cubby.action.ActionContext;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.internal.controller.ThreadContext;
import org.seasar.cubby.internal.util.RequestUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionUtils {
    public static ActionContext actionContext() {
        ThreadContext currentContext = ThreadContext.getCurrentContext();
        HttpServletRequest request = currentContext.getRequest();
        return ActionUtils.actionContext((ServletRequest)request);
    }

    public static ActionContext actionContext(ServletRequest request) {
        ActionContext actionContext = (ActionContext)RequestUtils.getAttribute(request, "org.seasar.cubby.actionContext");
        return actionContext;
    }

    public static boolean isActionClass(Class<?> clazz) {
        if (Action.class.isAssignableFrom(clazz)) {
            return true;
        }
        return clazz.isAnnotationPresent(ActionClass.class);
    }

    public static boolean isActionMethod(Method method) {
        return ActionResult.class.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0;
    }
}

