/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.plugins.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceServletContextListener;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubbyGuiceServletContextListener
extends GuiceServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger((String)CubbyGuiceServletContextListener.class.getName());
    public static final String MODULE_INIT_PARAM_NAME = "cubby.guice.module";
    private String[] moduleClassNames;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        String moduleClassNamesString = servletContext.getInitParameter(MODULE_INIT_PARAM_NAME);
        if (moduleClassNamesString == null || moduleClassNamesString.length() == 0) {
            throw new IllegalArgumentException("No context parameter \"cubby.guice.module\", please set Module FQCN");
        }
        this.moduleClassNames = moduleClassNamesString.split(",");
        super.contextInitialized(servletContextEvent);
    }

    protected Module createModule(String moduleClassName) {
        if (logger.isInfoEnabled()) {
            logger.info("Instantiates " + moduleClassName);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = Class.forName(moduleClassName, true, loader);
            Module module = (Module)Module.class.cast(clazz.newInstance());
            return module;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Illegal module " + moduleClassName, e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Illegal module " + moduleClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Illegal module " + moduleClassName, e);
        }
    }

    protected Injector getInjector() {
        ArrayList<Module> modules = new ArrayList<Module>();
        for (String moduleClassName : this.moduleClassNames) {
            Module module = this.createModule(moduleClassName.trim());
            modules.add(module);
        }
        return Guice.createInjector(modules);
    }
}

