/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.j2ee;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.util.StringUtil;

public class JndiResourceLocator {
    public static final String ENC_PREFIX = "java:comp/env/";
    protected static final Map MAGIC_COMPONENTS = new HashMap();

    public static Object lookup(String name) throws NamingException {
        return JndiResourceLocator.lookup(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object lookup(String name, Hashtable env) throws NamingException {
        InitialContext context = new InitialContext(env);
        try {
            Object object = context.lookup(name);
            return object;
        }
        finally {
            context.close();
        }
    }

    public static String resolveName(Name name) {
        return JndiResourceLocator.resolveName(name.toString());
    }

    public static String resolveName(String name) {
        String n = name;
        if (MAGIC_COMPONENTS.containsKey(name)) {
            n = (String)MAGIC_COMPONENTS.get(name);
        }
        if (name.startsWith(ENC_PREFIX)) {
            n = name.substring(ENC_PREFIX.length());
        }
        return StringUtil.replace((String)n, (String)"/", (String)ContainerConstants.NS_SEP_STR);
    }

    static {
        MAGIC_COMPONENTS.put("java:comp/UserTransaction", "jta/UserTransaction");
        MAGIC_COMPONENTS.put("java:comp/TransactionSynchronizationRegistry", "jta/TransactionSynchronizationRegistry");
    }
}

