/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.fileupload.FileItem;
import org.seasar.cubby.validator.MessageHelper;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;

public class FileRegexpValidator
implements ScalarFieldValidator {
    private final MessageHelper messageHelper;
    private final Pattern pattern;

    public FileRegexpValidator(String regex) {
        this(regex, "valid.fileRegexp");
    }

    public FileRegexpValidator(String regex, String messageKey) {
        this(Pattern.compile(regex), messageKey);
    }

    public FileRegexpValidator(Pattern pattern) {
        this(pattern, "valid.fileRegexp");
    }

    public FileRegexpValidator(Pattern pattern, String messageKey) {
        this.pattern = pattern;
        this.messageHelper = new MessageHelper(messageKey);
    }

    public void validate(ValidationContext context, Object value) {
        FileItem fileItem;
        Matcher matcher;
        if (value instanceof FileItem && !(matcher = this.pattern.matcher((fileItem = (FileItem)value).getName())).matches()) {
            context.addMessageInfo(this.messageHelper.createMessageInfo(new Object[0]));
        }
    }
}

