/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.tags;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.SimpleTag;
import org.seasar.cubby.action.ActionErrors;
import org.seasar.cubby.tags.CubbyFunctions;
import org.seasar.cubby.tags.DynamicAttributesTagSupport;
import org.seasar.cubby.tags.TagUtils;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.ArrayUtil;

public class InputTag
extends DynamicAttributesTagSupport {
    private static final String[] MULTIPLE_VALUE_TYPES = new String[]{"checkbox", "radio"};
    private String type;
    private String name;
    private Object value;
    private String checkedValue;
    private Integer index;

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCheckedValue(String checkedValue) {
        this.checkedValue = checkedValue;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void doTag() throws JspException, IOException {
        JspContext context = this.getJspContext();
        JspWriter out = context.getOut();
        ActionErrors errors = TagUtils.errors(context);
        Map<String, Object> dyn = this.getDynamicAttribute();
        String[] outputValues = TagUtils.getOutputValues((SimpleTag)this, this.name);
        if (this.index == null) {
            if (!errors.getFields().get(this.name).isEmpty()) {
                TagUtils.addClassName(dyn, "fieldError");
            }
        } else if (!errors.getIndexedFields().get(this.name).get(this.index).isEmpty()) {
            TagUtils.addClassName(dyn, "fieldError");
        }
        if (ArrayUtil.contains((Object[])MULTIPLE_VALUE_TYPES, (Object)this.type)) {
            if (this.value == null) {
                throw new JspTagException(MessageFormatter.getMessage((String)"ECUB1003", (Object[])new Object[]{Arrays.deepToString(MULTIPLE_VALUE_TYPES), "value"}));
            }
            Object[] values = TagUtils.multipleFormValues(context, outputValues, this.name, this.checkedValue);
            out.write("<input type=\"");
            out.write(this.type);
            out.write("\" name=\"");
            out.write(this.name);
            out.write("\" value=\"");
            out.write(CubbyFunctions.out(this.value));
            out.write("\" ");
            out.write(TagUtils.toAttr(dyn));
            out.write(" ");
            out.write(InputTag.checked(InputTag.toString(this.value), values));
            out.write("/>");
        } else {
            Object value = TagUtils.formValue(context, outputValues, this.name, this.index, this.value);
            out.write("<input type=\"");
            out.write(this.type);
            out.write("\" name=\"");
            out.write(this.name);
            out.write("\" value=\"");
            out.write(CubbyFunctions.out(InputTag.toString(value)));
            out.write("\" ");
            out.write(TagUtils.toAttr(dyn));
            out.write("/>");
        }
    }

    private static String checked(String value, Object values) {
        if (value == null || values == null) {
            return "";
        }
        if (TagUtils.contains(values, value)) {
            return "checked=\"checked\"";
        }
        return "";
    }
}

