/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.controller.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.seasar.cubby.action.Action;
import org.seasar.cubby.action.Form;
import org.seasar.cubby.action.RequestParameter;
import org.seasar.cubby.action.RequestParameterBindingType;
import org.seasar.cubby.controller.RequestParameterBinder;
import org.seasar.cubby.converter.ConversionHelper;
import org.seasar.cubby.converter.Converter;
import org.seasar.cubby.converter.ConverterFactory;
import org.seasar.cubby.util.CubbyUtils;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.ParameterizedClassDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestParameterBinderImpl
implements RequestParameterBinder {
    private ConverterFactory converterFactory;
    private ConversionHelper conversionHelper;

    public void setConverterFactory(ConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    public void setConversionHelper(ConversionHelper conversionHelper) {
        this.conversionHelper = conversionHelper;
    }

    @Override
    public void bind(Map<String, Object[]> parameterMap, Object dest, Class<? extends Action> actionClass, Method method) {
        if (parameterMap == null) {
            return;
        }
        BeanDesc destBeanDesc = BeanDescFactory.getBeanDesc(dest.getClass());
        for (Map.Entry<String, Object[]> entry : parameterMap.entrySet()) {
            RequestParameter requestParameter;
            PropertyDesc destPropertyDesc;
            String sourceName = entry.getKey();
            if (!destBeanDesc.hasPropertyDesc(sourceName) || !(destPropertyDesc = destBeanDesc.getPropertyDesc(sourceName)).isReadable() || !destPropertyDesc.isWritable() || !RequestParameterBinderImpl.isBindToAllProperties(actionClass, method) && (requestParameter = RequestParameterBinderImpl.getRequestParameterAnnotation(destPropertyDesc)) == null) continue;
            try {
                Object value = this.convert(entry.getValue(), destPropertyDesc);
                destPropertyDesc.setValue(dest, value);
            }
            catch (Exception e) {
                destPropertyDesc.setValue(dest, null);
            }
        }
    }

    private Object convert(Object[] values, PropertyDesc destPropertyDesc) {
        Class destClass = destPropertyDesc.getPropertyType();
        Converter converter = this.converterFactory.getConverter(values[0].getClass(), destClass);
        if (converter != null) {
            return converter.convertToObject(values[0], destClass, this.conversionHelper);
        }
        if (destClass.isArray()) {
            return this.convertToArray(values, destClass.getComponentType());
        }
        if (List.class.isAssignableFrom(destClass)) {
            ArrayList<Object> list = new ArrayList<Object>();
            this.convertToCollection(values, list, destPropertyDesc);
            return list;
        }
        if (Set.class.isAssignableFrom(destClass)) {
            LinkedHashSet<Object> set = new LinkedHashSet<Object>();
            this.convertToCollection(values, set, destPropertyDesc);
            return set;
        }
        return this.convertToScalar(values[0], destClass);
    }

    private Object convertToArray(Object[] values, Class<?> componentType) {
        Object dest = Array.newInstance(componentType, values.length);
        for (int i = 0; i < values.length; ++i) {
            Object convertedValue = this.convertToScalar(values[i], componentType);
            Array.set(dest, i, convertedValue);
        }
        return dest;
    }

    private void convertToCollection(Object[] values, Collection<Object> collection, PropertyDesc propertyDesc) {
        if (propertyDesc.isParameterized()) {
            ParameterizedClassDesc parameterizedClassDesc = propertyDesc.getParameterizedClassDesc();
            Class destElementType = parameterizedClassDesc.getArguments()[0].getRawClass();
            for (Object value : values) {
                Object convertedValue = this.convertToScalar(value, destElementType);
                collection.add(convertedValue);
            }
        } else {
            for (Object value : values) {
                collection.add(value);
            }
        }
    }

    private Object convertToScalar(Object value, Class<?> destClass) {
        if (value == null) {
            return null;
        }
        if (destClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        Converter converter = this.converterFactory.getConverter(value.getClass(), destClass);
        if (converter == null) {
            return null;
        }
        return converter.convertToObject(value, destClass, this.conversionHelper);
    }

    private static boolean isBindToAllProperties(Class<? extends Action> actionClass, Method method) {
        Form form = CubbyUtils.getForm(actionClass, method);
        if (form == null) {
            return false;
        }
        RequestParameterBindingType type = form.bindingType();
        switch (type) {
            case ALL_PROPERTIES: {
                return true;
            }
            case ONLY_SPECIFIED_PROPERTIES: {
                return false;
            }
        }
        throw new IllegalStateException(type.toString());
    }

    private static RequestParameter getRequestParameterAnnotation(PropertyDesc propertyDesc) {
        RequestParameter request;
        if (propertyDesc.hasWriteMethod()) {
            Method method = propertyDesc.getWriteMethod();
            if (method.isAnnotationPresent(RequestParameter.class)) {
                request = method.getAnnotation(RequestParameter.class);
            } else {
                Field field = propertyDesc.getField();
                request = field.getAnnotation(RequestParameter.class);
            }
        } else {
            Field field = propertyDesc.getField();
            request = field.getAnnotation(RequestParameter.class);
        }
        return request;
    }
}

