/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.seasar.framework.exception.IORuntimeException;

public class QueryStringBuilder {
    private StringBuilder queryString = new StringBuilder();
    private String encode = "UTF-8";
    private final String baseUri;

    public QueryStringBuilder() {
        this(null);
    }

    public QueryStringBuilder(String baseUrl) {
        this.baseUri = baseUrl;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    public void addParam(String name, Object value) {
        if (value != null && value.getClass().isArray()) {
            Object[] values;
            for (Object v : values = (Object[])value) {
                this.appendParams(name, v);
            }
        } else {
            this.appendParams(name, value);
        }
    }

    public String toString() {
        if (this.baseUri == null) {
            return this.queryString.toString();
        }
        StringBuilder baseUrlBuf = new StringBuilder(this.baseUri);
        if (baseUrlBuf.indexOf("?") == -1) {
            baseUrlBuf.append("?");
        } else if (this.queryString.indexOf("?") < this.queryString.length()) {
            baseUrlBuf.append("&");
        }
        return baseUrlBuf.toString() + this.queryString.toString();
    }

    private void appendParams(String name, Object value) {
        if (this.queryString.length() > 0) {
            this.queryString.append("&");
        }
        try {
            this.queryString.append(URLEncoder.encode(name, this.encode));
            this.queryString.append("=");
            if (value != null) {
                this.queryString.append(URLEncoder.encode(value.toString(), this.encode));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException((IOException)e);
        }
    }
}

